<?php
session_start();
require_once('lib/htm.php');

// Connessione al DB
if (!isset($dbc)) {
    exit('Database connection not established.');
}

// Recupera l'IP reale
$user_ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['REMOTE_ADDR'];

// Controllo se l'utente ha già un account
$get_user = $dbc->prepare('SELECT * FROM users WHERE ip = ? ORDER BY user_level DESC LIMIT 1');
if (!$get_user) exit('Prepare failed: ' . $dbc->error);
$get_user->bind_param('s', $user_ip);
if (!$get_user->execute()) exit('Execute failed: ' . $get_user->error);
$user_result = $get_user->get_result();
$user = $user_result->fetch_assoc();

if ($user_result->num_rows > 0 && $user['user_level'] < 1) {
    exit('You\'ve already made an account on your network.');
}

// Controllo proxy
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => 'http://check.getipintel.net/check.php?ip=' . $user_ip . '&contact=energeticbark37@gmail.com&flags=f',
    CURLOPT_RETURNTRANSFER => true
]);
$is_proxy = curl_exec($ch);
curl_close($ch);

if ($is_proxy > 0.99) {
    exit('You can\'t create an account when using a proxy.');
}

// Se l'utente non è loggato
if (empty($_SESSION['signed_in'])) {

    if ($_SERVER['REQUEST_METHOD'] != 'POST') {
        // Mostra il form
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta name="viewport" content="width=device-width, minimum-scale=1, maximum-scale=1">
            <link rel="stylesheet" href="/assets/css/login.css">
            <title>Create an account</title>
        </head>
        <body>
        <div class="hb-contents-wrapper">
            <div class="hb-container hb-l-inside">
                <h2>Sign Up</h2>
                <p>Create a User ID for Citraverse.</p>
            </div>

            <form method="post" enctype="multipart/form-data">
                <div class="hb-container hb-l-inside-half hb-mg-top-none">
                    <div class="auth-input-double">
                        <label><input type="text" name="username" maxlength="16" placeholder="User ID"></label>
                        <label><input type="password" name="password" maxlength="16" placeholder="Password"></label>
                        <label><input type="password" name="confirm_password" maxlength="16" placeholder="Confirm Password"></label>
                        <label><input type="text" name="name" maxlength="16" placeholder="Name"></label>
                        <input type="submit" name="submit" class="hb-btn hb-is-decide" value="Sign Up" style="margin-top:4px;">
                    </div>
                </div>
            </form>
        </div>
        </body>
        </html>
        <?php
    } else {
        // Elaborazione POST
        if (isset($_POST['submit'])) {
            $errors = [];

            // Validazione username
            $username = trim($_POST['username']);
            if (empty($username)) $errors[] = 'User ID cannot be empty.';
            if (strlen($username) > 16) $errors[] = 'User ID cannot be longer than 16 characters.';
            if (preg_match("/([%\$#\*\/\ ]+)/", $username)) $errors[] = 'User ID cannot contain special characters or spaces.';

            // Validazione password
            $password = $_POST['password'] ?? '';
            $confirm_password = $_POST['confirm_password'] ?? '';
            if (empty($password)) $errors[] = 'Password cannot be empty.';
            if ($password !== $confirm_password) $errors[] = 'Passwords do not match.';

            // Validazione nome
            $name = trim($_POST['name']);
            if (empty($name)) $errors[] = 'Name cannot be empty.';
            if (strlen($name) > 16) $errors[] = 'Name cannot be longer than 16 characters.';

            // Controllo username già esistente
            $search_user = $dbc->prepare('SELECT * FROM users WHERE user_name = ? LIMIT 1');
            if (!$search_user) exit('Prepare failed: ' . $dbc->error);
            $search_user->bind_param('s', $username);
            if (!$search_user->execute()) exit('Execute failed: ' . $search_user->error);
            $user_result = $search_user->get_result();
            if ($user_result->num_rows > 0) $errors[] = 'User ID already exists.';

            // Gestione avatar / Mii
            $face = '/assets/images/default-avatar.png';
            $face_type = 'image'; // valore default corretto

            // Se ci sono errori
            if (!empty($errors)) {
                echo '<script>alert("' . implode('\\n', $errors) . '");</script>';
                echo '<meta http-equiv="refresh" content="0;URL=/signup">';
                exit;
            }

            // Inserimento utente nel DB
            $password_hash = password_hash($password, PASSWORD_DEFAULT);
            $new_user = $dbc->prepare('INSERT INTO users (user_name, user_pass, nickname, user_face, face_type, date_created, ip) VALUES (?,?,?,?,?,NOW(),?)');
            if (!$new_user) exit('Prepare failed: ' . $dbc->error);
            $new_user->bind_param('ssssss', $username, $password_hash, $name, $face, $face_type, $user_ip);
            if (!$new_user->execute()) {
                exit('DB error: ' . $new_user->error);
            }

            // Recupero ID appena inserito
            $user_id = $dbc->insert_id;

            if (!$user_id) {
                exit('There was an error creating your account, please try again.');
            }

            // Creazione profilo
            $new_profile = $dbc->prepare('INSERT INTO profiles (user_id) VALUES (?)');
            if (!$new_profile) exit('Prepare failed: ' . $dbc->error);
            $new_profile->bind_param('i', $user_id);
            if (!$new_profile->execute()) exit('DB error: ' . $new_profile->error);

            // Login automatico
            $_SESSION['signed_in'] = true;
            $_SESSION['user_id'] = $user_id;
            echo '<meta http-equiv="refresh" content="0;URL=/">';
        }
    }
}
?>