<?php
require_once('lib/htm.php');
require_once('lib/htmUsers.php');

if(empty($_SESSION['signed_in'])){
    $tabTitle = 'Citraverse';
    printHeader('');
    echo '<div class="warning-content warning-content-forward"><div><strong>Welcome to Citraverse!</strong><p>You must sign in to view this page.</p>
    <a class="button" href="/">Home</a></div></div>';
} else {

    function validateDate($date, $format = 'Y-m-d H:i:s') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

    if($_SERVER['REQUEST_METHOD'] != 'POST'){
        // --- GET: mostra form ---
        $get_user = $dbc->prepare('SELECT * FROM users INNER JOIN profiles ON profiles.user_id = users.user_id WHERE users.user_id = ? LIMIT 1');
        $get_user->bind_param('i', $_SESSION['user_id']);
        $get_user->execute();
        $user_result = $get_user->get_result();
        $user = $user_result->fetch_assoc();

        $tabTitle = 'Citraverse - Profile Settings';
        printHeader('');

        echo '<div id="sidebar" class="user-sidebar">';
        userContent($user, "settings");
        userSidebarSetting($user, 0);
        userInfo($user);
        echo '</div><div class="main-column"><div class="post-list-outline"><h2 class="label">Profile Settings</h2>';

        echo '<form class="setting-form" action="" method="post" enctype="multipart/form-data">
          <ul class="settings-list">
            <li class="setting-profile-comment">
              <p class="settings-label">Profile Comment</p>
              <textarea id="profile-text" class="textarea" name="profile_comment" maxlength="400" placeholder="Write about yourself here.">'. htmlspecialchars($user['bio'], ENT_QUOTES) .'</textarea>
            </li>

            <li>
              <p class="settings-label">Nickname</p>
              <input class="textarea" placeholder="Change your nickname here." type="text" maxlength="16" name="name" style="cursor:auto;height:auto;" value="'. htmlspecialchars($user['nickname'], ENT_QUOTES) .'" />
            </li>

            <li>
              <p class="settings-label">Profile Picture</p>
              <input type="file" name="face" accept="image/*">
              <p class="note">Recommended: 96x96px square image.</p>
            </li>
          </ul>
          <div class="form-buttons">
            <input type="submit" name="submit" class="black-button apply-button" value="Save Settings" />
          </div>
        </form></div></div></div></div>';

    } else {
        // --- POST: salva dati ---
        $errors = [];

        // Nickname
        if(!empty($_POST['name'])){
            if(strlen($_POST['name']) > 16){
                $errors[] = 'Name cannot be longer than 16 characters';
            } else {
                $name = $_POST['name'];
                $user_change = $dbc->prepare('UPDATE users SET nickname = ? WHERE user_id = ?');
                $user_change->bind_param('si', $name, $_SESSION['user_id']);
                $user_change->execute();
            }
        }

        // Profile comment
        if(!empty($_POST['profile_comment'])){
            if(strlen($_POST['profile_comment']) > 400){
                $errors[] = 'Profile comment cannot exceed 400 characters';
            } else {
                $bio = htmlspecialchars($_POST['profile_comment'], ENT_QUOTES);
                $user_change = $dbc->prepare('UPDATE profiles SET bio = ? WHERE user_id = ?');
                $user_change->bind_param('si', $bio, $_SESSION['user_id']);
                $user_change->execute();
            }
        } else {
            $user_change = $dbc->prepare('UPDATE profiles SET bio = NULL WHERE user_id = ?');
            $user_change->bind_param('i', $_SESSION['user_id']);
            $user_change->execute();
        }

        // Profile picture
        if(!empty($_FILES['face']['name'])){
            $img = $_FILES['face'];
            $username_clean = preg_replace('/[^a-zA-Z0-9_-]/', '', strtolower($user['user_name']));
            $uploadDir = __DIR__ . "/Immagini/";
            if(!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

            $ext = strtolower(pathinfo($img['name'], PATHINFO_EXTENSION));
            $filename = $uploadDir . $username_clean . "_pfp." . $ext;

            if(move_uploaded_file($img['tmp_name'], $filename)){
                $faceUrl = "https://citraverse.altervista.org/Immagini/" . $username_clean . "_pfp." . $ext;
                $user_change = $dbc->prepare('UPDATE users SET user_face = ? WHERE user_id = ?');
                $user_change->bind_param('si', $faceUrl, $_SESSION['user_id']);
                $user_change->execute();
            } else {
                $errors[] = 'Profile picture upload failed.';
            }
        }

        if(empty($errors)){
            echo 'Settings saved.';
        } else {
            echo $errors[0];
        }
    }
}
?>
