<?php
require_once('lib/htm.php');
require_once('lib/htmUsers.php');

if(empty($_SESSION['signed_in'])){
    $tabTitle = 'Citraverse';
    printHeader('');
    echo '<div class="warning-content warning-content-forward"><div><strong>Welcome to Citraverse!</strong><p>You must sign in to view this page.</p>
    <a class="button" href="/">Citraverse</a></div></div>';
} else {

    function validateDate($date, $format = 'Y-m-d H:i:s') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

    if($_SERVER['REQUEST_METHOD'] != 'POST'){
        $get_user = $dbc->prepare('SELECT * FROM users INNER JOIN profiles ON profiles.user_id = users.user_id WHERE users.user_id = ? LIMIT 1');
        $get_user->bind_param('i', $_SESSION['user_id']);
        $get_user->execute();
        $user_result = $get_user->get_result();
        $user = $user_result->fetch_assoc();

        $tabTitle = 'Citraverse - Profile Settings';
        printHeader('');

        $post_count = $dbc->prepare('SELECT COUNT(id) FROM posts WHERE post_by_id = ?');
        $post_count->bind_param('i', $user['user_id']);
        $post_count->execute();
        $result_count = $post_count->get_result();
        $post_amount = $result_count->fetch_assoc();

        $yeah_count = $dbc->prepare('SELECT COUNT(yeah_by) FROM yeahs WHERE yeah_by = ?');
        $yeah_count->bind_param('i', $user['user_id']);
        $yeah_count->execute();
        $result_count = $yeah_count->get_result();
        $yeah_amount = $result_count->fetch_assoc();

        echo '<div id="sidebar" class="user-sidebar">';
        userContent($user, "settings");
        userSidebarSetting($user, 0);
        userInfo($user);
        echo '</div><div class="main-column"><div class="post-list-outline"><h2 class="label">Profile Settings</h2>';

        $get_prof = $dbc->prepare('SELECT * FROM profiles INNER JOIN posts ON id = fav_post AND deleted = 0 WHERE user_id = ?');
        $get_prof->bind_param('i', $user['user_id']);
        $get_prof->execute();
        $prof_result = $get_prof->get_result();
        $profile = $prof_result->fetch_assoc();
        if(is_null($profile['country'])){
          $profile['country'] = 0;
        }

        echo '<form class="setting-form" action="" method="post" enctype="multipart/form-data">
          <ul class="settings-list">
            <li class="setting-profile-comment">
              <p class="settings-label">Profile Comment</p>
              <textarea id="profile-text" class="textarea" name="profile_comment" maxlength="400" placeholder="Write about yourself here.">'. $user['bio'] .'</textarea>
            </li>

            <li>
              <p class="settings-label">Nickname</p>
              <input class="textarea" placeholder="Change your nickname here." type="text" maxlength="69" name="name" style="cursor: auto; height: auto;" value="'. htmlspecialchars($user['nickname'], ENT_QUOTES) .'" />
            </li>

            <li class="setting-profile-post">
              <p class="settings-label">Favorite Post</p>
              <p class="note">You can set one of your posts as your favorite via the settings button of that post.</p>
              '. (isset($profile['post_image']) ? '<div class="select-content"><button id="profile-post" type="button" class="submit"><span class="better-fav-button" style="background-image:url('. $profile['post_image'] .')"></span><span class="symbol">Remove Favorite Post</span></button></div>':'') .'
            </li>

            <li>
              <div class="custom-face">
                <p class="settings-label">Profile picture upload</p>
                <p>Type:</p>
                <p>Image <input type="radio" name="facetype" value="image" checked/></p>
                <p>Mii (NNID) <input type="radio" name="facetype" value="nnidmii" /></p>
                <p>Mii (PNID) <input type="radio" name="facetype" value="pnidmii" /></p>
                <p>Mii (raw data) <input type="radio" name="facetype" value="ariankordi" /></p>
                <p>Image upload (for the image type)</p>
                <input type="file" name="face" accept="image/*">
                <p>Text data (for other types)</p>
                <input type="text" name="facet" />
              </div>
            </li>

            <li>
              <p class="settings-label"><label for="select_notify.empathy_notice_opt_out">Change the color of your name.</label></p>
              <div class="select-content">
                <div class="select-button">
                  <input type="color" name="name-color" value="'. (isset($user['name_color']) ? $user['name_color'] : '#ffffff').'" style="height: 24px;margin-right: 5px;vertical-align: middle;">
                  <input type="button" value="reset to default" onclick="$(\'input[type=\\\'color\\\']\').remove();" style="
                  border: none;
                  background-color: #efefef;
                  padding: 5px;
                  border-radius: 3px;
                  border: #aeaeae 1px solid;">
                </div>
              </div>
            </li>

            <li>
              <p class="settings-label"><label for="select_country">Country</label></p>
              <div class="select-content">
                <div class="select-button">
                  <select name="country" id="select_country">
                    <option value="1" '.($profile['country']==1 ? 'selected' : '').'>United States</option>
                    <option value="2" '.($profile['country']==2 ? 'selected' : '').'>Greece</option>
                    <option value="3" '.($profile['country']==3 ? 'selected' : '').'>France</option>
                    <option value="4" '.($profile['country']==4 ? 'selected' : '').'>Spain</option>
                    <option value="5" '.($profile['country']==5 ? 'selected' : '').'>Italy</option>
                    <option value="6" '.($profile['country']==6 ? 'selected' : '').'>Brazil</option>
                    <option value="7" '.($profile['country']==7 ? 'selected' : '').'>Japan</option>
                    <option value="8" '.($profile['country']==8 ? 'selected' : '').'>South Korea</option>
                    <option value="9" '.($profile['country']==9 ? 'selected' : '').'>San Marino</option>
                    <option value="10" '.($profile['country']==10 ? 'selected' : '').'>Canada</option>
                    <option value="11" '.($profile['country']==11 ? 'selected' : '').'>Romania</option>
                    <option value="12" '.($profile['country']==12 ? 'selected' : '').'>Poland</option>
                    <option value="13" '.($profile['country']==13 ? 'selected' : '').'>Netherlands</option>
                    <option value="14" '.($profile['country']==14 ? 'selected' : '').'>Sweden</option>
                    <option value="15" '.($profile['country']==15 ? 'selected' : '').'>Switzerland</option>
                    <option value="16" '.($profile['country']==16 ? 'selected' : '').'>United Kingdom</option>
                    <option value="17" '.($profile['country']==17 ? 'selected' : '').'>Germany</option>
                    <option value="18" '.($profile['country']==18 ? 'selected' : '').'>Finland</option>
                    <option value="19" '.($profile['country']==19 ? 'selected' : '').'>Denmark</option>
                    <option value="20" '.($profile['country']==20 ? 'selected' : '').'>Belgium</option>
                    <option value="21" '.($profile['country']==21 ? 'selected' : '').'>Albania</option>
                    <option value="22" '.($profile['country']==22 ? 'selected' : '').'>Vietnam</option>
                    <option value="23" '.($profile['country']==23 ? 'selected' : '').'>Peru</option>
                    <option value="24" '.($profile['country']==24 ? 'selected' : '').'>Mexico</option>
                    <option value="25" '.($profile['country']==25 ? 'selected' : '').'>Paraguay</option>
                    <option value="26" '.($profile['country']==26 ? 'selected' : '').'>Argentina</option>
                    <option value="27" '.($profile['country']==27 ? 'selected' : '').'>Costa Rica</option>
                    <option value="28" '.($profile['country']==28 ? 'selected' : '').'>Philippines</option>
                    

                </div>
              </div>
            </li>
            
            
            

            <li>
              <p class="settings-label"><label for="select_birthday">When is your Birthday?</label></p>
              <div class="select-content">
                <div class="select-button">
                  <input type="date" name="birthday" min="2017-01-01" max="2017-12-31" value="'. (isset($user['birthday']) ? date('Y-m-d', strtotime($user['birthday'])) : '') .'" style="width: auto; max-width: 100%; min-width: 50%; font-size: 16px;">
                </div>
              </div>
              <p class="note">Only the day and month are stored.</p>
            </li>
          </ul>
          <div class="form-buttons">
            <input type="submit" name="submit" class="black-button apply-button" value="Save Settings" />
          </div>
        </form></div></div></div></div>';
    } else {

        $errors = [];

        // Aggiorna nickname
        if(!empty($_POST['name'])){
            if(strlen($_POST['name']) > 69){
                $errors[] = 'Name cannot be longer than 69 characters';
            } else {
                $name = $_POST['name'];
                $user_change = $dbc->prepare('UPDATE users SET nickname = ? WHERE users.user_id = ?');
                $user_change->bind_param('si', $name, $_SESSION['user_id']);
                $user_change->execute();
            }
        }

        // Aggiorna compleanno
        if(isset($_POST['birthday']) && validateDate($_POST['birthday'], 'Y-m-d')){
            $birthday = date('Y-m-d', strtotime($_POST['birthday']));
            $user_change = $dbc->prepare('UPDATE profiles SET birthday = ? WHERE user_id = ?');
            $user_change->bind_param('si', $birthday, $_SESSION['user_id']);
            $user_change->execute();
        }

        // Aggiorna country
        if(in_array($_POST['country'], [1,2,3,4,5,6,7])){
            $user_change = $dbc->prepare('UPDATE profiles SET country = ? WHERE user_id = ?');
            $user_change->bind_param('ii', $_POST['country'], $_SESSION['user_id']);
            $user_change->execute();
        }

        // Aggiorna profile comment
        if(!empty($_POST['profile_comment'])){
            if(strlen($_POST['profile_comment']) > 400){
                $errors[] = 'Profile Comment cannot be longer than 400 characters';
            } else {
                $bio = htmlspecialchars($_POST['profile_comment'], ENT_QUOTES);
                $user_change = $dbc->prepare('UPDATE profiles SET bio = ? WHERE user_id = ?');
                $user_change->bind_param('si', $bio, $_SESSION['user_id']);
                $user_change->execute();
            }
        } else {
            $user_change = $dbc->prepare('UPDATE profiles SET bio = NULL WHERE user_id = ?');
            $user_change->bind_param('i', $_SESSION['user_id']);
            $user_change->execute();
        }

        // Aggiorna colore nome
        if (isset($_POST['name-color']) && $_POST['name-color'] !== '#ffffff') {
            $user_change = $dbc->prepare('UPDATE profiles SET name_color = ? WHERE user_id = ?');
            $user_change->bind_param('si', $_POST['name-color'], $_SESSION['user_id']);
            $user_change->execute();
        } else {
            $user_change = $dbc->prepare('UPDATE profiles SET name_color = NULL WHERE user_id = ?');
            $user_change->bind_param('i', $_SESSION['user_id']);
            $user_change->execute();
        }

        // Upload immagine profilo (mantenuta in /membri/citraverse/assets/images/)
        if($_POST["facetype"] == "image"){
          $facetype = $_POST["facetype"];
          if (!empty($_FILES['face']['name'])) {
            $img = $_FILES['face'];
            $ext = strtolower(pathinfo($img['name'], PATHINFO_EXTENSION));
            $allowed = ['jpg','jpeg','png','gif'];

            if(!in_array($ext, $allowed)){
                $errors[] = 'Invalid image format. Allowed: jpg, jpeg, png, gif';
            } else {
                $username = $_SESSION['nickname'] ?? 'user'.$_SESSION['user_id'];
                $target_dir = __DIR__ . '/assets/images/';
                if(!file_exists($target_dir)){
                    mkdir($target_dir, 0755, true);
                }

                $target_file = $target_dir . $username . '.' . $ext;

                if(move_uploaded_file($img['tmp_name'], $target_file)){
                    $db_path = '/assets/images/' . $username . '.' . $ext;
                    $user_change = $dbc->prepare('UPDATE users SET user_face = ?, face_type = ? WHERE users.user_id = ?');
                    $user_change->bind_param('ssi', $db_path, $facetype, $_SESSION['user_id']);
                    $user_change->execute();
                } else {
                  $db_path = '/assets/images/default-avatar.png';
                  $user_change = $dbc->prepare('UPDATE users SET user_face = ?, face_type = ? WHERE users.user_id = ?');
                  $user_change->bind_param('ssi', $db_path, $facetype, $_SESSION['user_id']);
                  $user_change->execute();
                    $errors[] = 'Image upload failed.';
                }
            }
        }  else {
          $db_path = '/assets/images/default-avatar.png';
          $user_change = $dbc->prepare('UPDATE users SET user_face = ?, face_type = ? WHERE users.user_id = ?');
          $user_change->bind_param('ssi', $db_path, $facetype, $_SESSION['user_id']);
          $user_change->execute();
            $errors[] = 'Image upload failed.';
        }
        } else {
          $facetype = $_POST["facetype"];
          $db_path = $_POST["facet"];
          $user_change = $dbc->prepare('UPDATE users SET user_face = ?, face_type = ? WHERE users.user_id = ?');
          $user_change->bind_param('ssi', $db_path, $facetype, $_SESSION['user_id']);
          $user_change->execute();
        }

        if(!empty($errors)){
            echo implode('<br>', $errors);
        } else {
            echo 'Settings saved.';
        }
    }
}
