<?php
header('Content-Type: application/json; charset=utf-8');

// Controlla se l’utente è loggato e prendi lo username dai cookie/sessione
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'guest'; // fallback se non loggato

$endpoints = [
    "community" => "https://citraverse.altervista.org/",
    "profile"   => "https://citraverse.altervista.org/users/$username/posts",
    "activity"  => "https://citraverse.altervista.org/activity",
    "messages"  => "https://citraverse.altervista.org/news/my_news"
];

$response = [
    "status" => "ok",
    "version" => "1.0",
    "endpoints" => $endpoints,
    "meta" => (object)[]
];

echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);

