<?php
require_once('lib/htm.php');
require_once('lib/htmUsers.php');

if (empty($_SESSION['signed_in'])) {
    exit('Please sign in');
}

// --- Controllo se l'utente ha già una community ---
$check_user_communities = $dbc->prepare('SELECT COUNT(*) AS total FROM titles WHERE title_by = ?');
$check_user_communities->bind_param('i', $_SESSION['user_id']);
$check_user_communities->execute();
$result = $check_user_communities->get_result();
$row = $result->fetch_assoc();
$userHasCommunity = ($row['total'] >= 1);

if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    // --- Pagina di creazione community ---
    $tabTitle = 'Citraverse - Community Creation';
    printHeader('');

    $get_user = $dbc->prepare('SELECT * FROM users 
        INNER JOIN profiles ON profiles.user_id = users.user_id 
        WHERE users.user_id = ? LIMIT 1');
    $get_user->bind_param('i', $_SESSION['user_id']);
    $get_user->execute();
    $user_result = $get_user->get_result();
    $user = $user_result->fetch_assoc();

    echo '<div id="sidebar" class="general-sidebar">';
    userContent($user, "");
    sidebarSetting();
    echo '</div>';
    echo '<div class="main-column">';
    echo '<div class="post-list-outline">';
    echo '<h2 class="label">Create a Community</h2>';

    if ($userHasCommunity) {
        // 🔒 BLOCCO QUI: non mostro form
        echo '<p style="color:red;font-weight:bold;">⚠️ You already created a community. You cannot create more.</p>';
    } else {
        // 🔓 Mostro il form solo se l’utente NON ha community
        ?>
        <form id="community-form" class="setting-form community-creation" 
              method="post" action="" enctype="multipart/form-data">
            <ul class="settings-list">
                <li>
                    <p class="settings-label">Community name</p>
                    <input class="textarea" placeholder="Your community name." 
                           type="text" maxlength="64" name="name" required>
                </li>

                <li>
                    <p class="settings-label">Description</p>
                    <textarea class="textarea" name="description" maxlength="400" 
                              placeholder="Your community description." required></textarea>
                </li>

                <li>
                    <p class="settings-label">Icon</p>
                    <p class="note">Recommended: 128x128px, square image.</p>
                    <input type="file" name="title_icon" accept="image/*" required>
                </li>

                <li>
                    <p class="settings-label">Banner</p>
                    <p class="note">Recommended: 347x145px.</p>
                    <input type="file" name="title_banner" accept="image/*" required>
                </li>

                <li>
                    <p class="settings-label">Private community</p>
                    <p class="note">Only you can post, others can comment.</p>
                    <div class="select-content">
                        <div class="select-button">
                            <select name="is_private">
                                <option value="0">Public</option>
                                <option value="1">Private</option>
                            </select>
                        </div>
                    </div>
                </li>
            </ul>
            <div class="form-buttons">
                <input type="submit" class="black-button apply-button" 
                       value="Create Community">
            </div>
        </form>
        <?php
    }

    echo '</div></div></div></div>';

} else {
    // --- Gestione form inviato ---
    if ($userHasCommunity) {
        // 🔒 Se provano a bypassare con POST manuale → stop
        exit('Error: You already own a community. You cannot create another one.');
    }

    $error = false;

    if (empty($_POST['name'])) {
        $error = 'Please write a name for your community.';
    }
    if (empty($_POST['description'])) {
        $error = 'Please write a description.';
    }

    // Controllo duplicati nome
    if (empty($error)) {
        $check_titles = $dbc->prepare('SELECT * FROM titles WHERE title_name = ?');
        $check_titles->bind_param('s', $_POST['name']);
        $check_titles->execute();
        $titles_result = $check_titles->get_result();

        if ($titles_result->num_rows > 0) {
            $error = 'A community with this name already exists.';
        }
    }

    if (empty($error)) {
        $communityName = preg_replace('/[^a-zA-Z0-9_-]/', '', strtolower($_POST['name']));
        $uploadDir = __DIR__ . "/Immagini/";
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        // --- Icona ---
        if (!empty($_FILES['title_icon']['name'])) {
            $ext = strtolower(pathinfo($_FILES['title_icon']['name'], PATHINFO_EXTENSION));
            $iconFile = $communityName . "_logo." . $ext;
            $iconPath = $uploadDir . $iconFile;
            if (!move_uploaded_file($_FILES['title_icon']['tmp_name'], $iconPath)) {
                $error = "Failed to upload icon.";
            }
            $iconUrl = "https://citraverse.altervista.org/Immagini/" . $iconFile;
        } else {
            $error = "Please upload an icon.";
        }

        // --- Banner ---
        if (empty($error) && !empty($_FILES['title_banner']['name'])) {
            $ext = strtolower(pathinfo($_FILES['title_banner']['name'], PATHINFO_EXTENSION));
            $bannerFile = $communityName . "_banner." . $ext;
            $bannerPath = $uploadDir . $bannerFile;
            if (!move_uploaded_file($_FILES['title_banner']['tmp_name'], $bannerPath)) {
                $error = "Failed to upload banner.";
            }
            $bannerUrl = "https://citraverse.altervista.org/Immagini/" . $bannerFile;
        } else if (empty($error)) {
            $error = "Please upload a banner.";
        }

        // --- Salvataggio DB ---
        if (empty($error)) {
            $new_community = $dbc->prepare('INSERT INTO titles 
                (title_id, title_name, title_desc, title_icon, title_banner, perm, type, user_made, title_by, owner_only) 
                VALUES (?,?,?,?,?,?,?,?,?,?)');

            $id = mt_rand(10000000, 99999999);
            $perm = 0;
            $type = 6;
            $user_made = 1;

            $new_community->bind_param(
                'issssiiiii',
                $id,
                $_POST['name'],
                $_POST['description'],
                $iconUrl,
                $bannerUrl,
                $perm,
                $type,
                $user_made,
                $_SESSION['user_id'],
                $_POST['is_private']
            );
            $new_community->execute();

            echo "Community created successfully.";
        } else {
            echo $error;
        }
    } else {
        echo $error;
    }
}
?>
