<!DOCTYPE html>
<html lang="en">
<head>
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Admin Panel</title>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta.2/css/bootstrap.min.css">
<style>
.tab-content > .tab-pane { display: none; }
.tab-content > .tab-pane.active { display: block; }
.nav-tabs .nav-link { cursor: pointer; }
</style>
</head>
<body class="m-4">
<h1>Citraverse Admin Panel</h1>

<!-- Tabs -->
<ul class="nav nav-tabs mb-3" id="customTabs">
    <li class="nav-item">
        <a class="nav-link active" data-tab="messages">Messages</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" data-tab="communities">Communities</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" data-tab="users">Users</a>
    </li>
</ul>

<div class="tab-content">

<!-- Messages -->
<div class="tab-pane active" id="messages">
    <div class="row">
        <!-- Delete Post -->
        <div class="col-sm-6 mb-3">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Delete Post</h4>
                    <form id="delete_post">
                        <input class="form-control mb-2" type="text" name="post_id" placeholder="Post ID">
                        <select name="post_violation_type" class="form-control mb-2">
                            <option value="">Select violation</option>
                            <option value="1">Spam</option>
                            <option value="2">Sexually Explicit</option>
                            <option value="0">Other</option>
                        </select>
                        <input type="submit" class="btn btn-primary float-right" value="Delete">
                    </form>
                </div>
            </div>
        </div>

        <!-- Delete Reply -->
        <div class="col-sm-6 mb-3">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Delete Reply</h4>
                    <form id="delete_reply">
                        <input class="form-control mb-2" type="text" name="reply_id" placeholder="Reply ID">
                        <select name="reply_violation_type" class="form-control mb-2">
                            <option value="">Select violation</option>
                            <option value="1">Spam</option>
                            <option value="2">Sexually Explicit</option>
                            <option value="0">Other</option>
                        </select>
                        <input type="submit" class="btn btn-primary float-right" value="Delete">
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Communities -->
<div class="tab-pane" id="communities">
    <div class="row">
        <div class="col-sm-6 mb-3">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Create Community</h4>
                    <form id="create_community" enctype="multipart/form-data">
                        <input class="form-control mb-2" type="text" name="name" placeholder="Community Name">
                        <textarea class="form-control mb-2" name="description" placeholder="Description"></textarea>
                        <label>Icon</label>
                        <input class="form-control mb-2" type="file" name="title_icon" accept="image/*">
                        <label>Banner</label>
                        <input class="form-control mb-2" type="file" name="title_banner" accept="image/*">
                        <label>Console</label>
                        <select name="console_type" class="form-control mb-2">
                            <option value="1">Wii U</option>
                            <option value="2">3DS</option>
                            <option value="3">Both</option>
                        </select>
                        <input type="submit" class="btn btn-success float-right" value="Create">
                    </form>
                </div>
            </div>
        </div>

        <!-- Delete Community -->
        <div class="col-sm-6 mb-3">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Delete Community</h4>
                    <form id="delete_community">
                        <input class="form-control mb-2" type="text" name="community_name" placeholder="Community Name">
                        <input type="submit" class="btn btn-danger float-right" value="Delete">
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Users -->
<div class="tab-pane" id="users">
    <div class="row">
        <!-- Delete User -->
        <div class="col-sm-6 mb-3">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Delete User</h4>
                    <form id="delete_user">
                        <input class="form-control mb-2" type="text" name="user_id" placeholder="User ID">
                        <input type="submit" class="btn btn-danger float-right" value="Delete">
                    </form>
                </div>
            </div>
        </div>

        <!-- Change User Role -->
        <div class="col-sm-6 mb-3">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Change User Role</h4>
                    <form id="change_role">
                        <input class="form-control mb-2" type="text" name="user_id" placeholder="User ID">
                        <select name="role" class="form-control mb-2">
                            <option value="0">Normal</option>
                            <option value="1">Admin</option>
                        </select>
                        <input type="submit" class="btn btn-primary float-right" value="Update Role">
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
<script>
$(document).ready(function(){
    // Tabs
    $('#customTabs .nav-link').click(function(){
        var tab = $(this).data('tab');
        $('#customTabs .nav-link').removeClass('active');
        $(this).addClass('active');
        $('.tab-content .tab-pane').removeClass('active');
        $('#' + tab).addClass('active');
    });

    // Example AJAX handlers (da collegare al tuo backend PHP o simile)
    $('#change_role').submit(function(e){
        e.preventDefault();
        var userId = $(this).find('[name="user_id"]').val();
        var role = $(this).find('[name="role"]').val();
        $.post('/change_user_role.php', {user_id: userId, role: role}, function(res){
            alert(res);
        });
    });

    $('#delete_community').submit(function(e){
        e.preventDefault();
        var name = $(this).find('[name="community_name"]').val();
        $.post('/delete_community.php', {name: name}, function(res){
            alert(res);
        });
    });
});
</script>
</body>
</html>
