<?php
// Leggi tutte le righe del file tomochat.txt
$lines = file('CHATC/tomochat.txt', FILE_IGNORE_NEW_LINES);

// Controlla se il file è stato letto correttamente
if ($lines === false) {
    die("Errore nella lettura del file.");
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Box con Testo</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            height: 100vh;
            background-color: #ffe0e0;
            flex-direction: column;
            overflow-x: hidden; /* Per evitare la barra di scorrimento orizzontale */
        }
        .container {
            display: flex;
            flex-direction: column; /* Dispone le box in una colonna */
            gap: 15px; /* Spazio tra le box */
            width: 100%; /* Larghezza della pagina */
            padding: 10px; /* Padding per evitare che le box tocchino i bordi */
            box-sizing: border-box; /* Include padding nella larghezza */
            overflow-y: auto; /* Aggiungi scroll verticale se necessario */
            max-height: 100%; /* Permette di adattarsi a tutta l'altezza della finestra */
        }
        .box {
            background-color: #f59a9a; /* Grigio più chiaro */
            padding: 10px; /* Ridotto il padding per una box più bassa */
            width: 100%; /* Larghezza 100% della pagina */
            min-height: 40px; /* Altezza minima per evitare che diventi troppo piccola */
            height: auto; /* Altezza automatica per contenere il testo */
            display: flex;
            justify-content: center;
            align-items: center;
            border-radius: 10px;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1);
            box-sizing: border-box; /* Include padding e bordi nella larghezza */
            word-wrap: break-word; /* Per far andare a capo il testo se necessario */
        }
        @media (max-width: 600px) {
            .box {
                font-size: 14px; /* Font più piccolo per schermi piccoli */
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <?php
        // Crea una box per ogni riga del file
        foreach ($lines as $index => $line) {
            echo "<div class='box'>".htmlspecialchars($line)."</div>";
        }
        ?>
    </div>
</body>
</html>
