<?php
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$id = $data['identificatore'] ?? '';
$voto = $data['voto'] ?? '';
$materia = $data['materia'] ?? '';
$descrizione = $data['descrizione'] ?? '';

if (!$id || !$voto || !$materia || !$descrizione) {
  echo json_encode(['success' => false, 'message' => 'Dati mancanti']);
  exit;
}

$folder = __DIR__ . "/$id";
$file = "$folder/voti.json";

if (!is_dir($folder)) {
  mkdir($folder, 0777, true);
}

$voti = [];

if (file_exists($file)) {
  $contenuto = file_get_contents($file);
  $voti = json_decode($contenuto, true);
  if (!is_array($voti)) $voti = [];
}

$voti[] = [
  "Voto" => $voto,
  "Materia" => $materia,
  "Descrizione" => $descrizione
];

file_put_contents($file, json_encode($voti, JSON_PRETTY_PRINT));

echo json_encode(['success' => true]);
