<?php
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$id = $data['identificatore'] ?? '';
$titolo = $data['titolo'] ?? '';
$descrizione = $data['descrizione'] ?? '';
$materia = $data['materia'] ?? '';
$tipo = $data['tipo'] ?? '';

if (!$id || !$titolo || !$descrizione || !$materia || !$tipo) {
  echo json_encode(['success' => false, 'message' => 'Dati mancanti']);
  exit;
}

$folder = __DIR__ . "/$id";
$file = "$folder/note.json";

if (!is_dir($folder)) {
  mkdir($folder, 0777, true);
}

$note = [];

if (file_exists($file)) {
  $contenuto = file_get_contents($file);
  $note = json_decode($contenuto, true);
  if (!is_array($note)) $note = [];
}

$note[] = [
  "Titolo" => $titolo,
  "Descrizione" => $descrizione,
  "Materia" => $materia,
  "Tipo" => $tipo
];

file_put_contents($file, json_encode($note, JSON_PRETTY_PRINT));

echo json_encode(['success' => true]);
