<?php
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$titolo = $data['titolo'] ?? '';
$descrizione = $data['descrizione'] ?? '';

if (!$titolo || !$descrizione) {
  echo json_encode(['success' => false, 'message' => 'Dati mancanti']);
  exit;
}

$file = __DIR__ . '/comunicazioni.json';
$comunicazioni = [];

if (file_exists($file)) {
  $contenuto = file_get_contents($file);
  $comunicazioni = json_decode($contenuto, true);
  if (!is_array($comunicazioni)) $comunicazioni = [];
}

$comunicazioni[] = [
  "Titolo" => $titolo,
  "Descrizione" => $descrizione
];

file_put_contents($file, json_encode($comunicazioni, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

echo json_encode(['success' => true]);
