<?php
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$id = $data['identificatore'] ?? '';
$dataCorrente = $data['data'] ?? '';
$orario = $data['orario'] ?? '';
$tipo = $data['tipo'] ?? '';

if (!$id || !$dataCorrente || !$orario || !$tipo) {
  echo json_encode(['success' => false, 'message' => 'Dati mancanti']);
  exit;
}

$folder = __DIR__ . "/$id";
$file = "$folder/assenze.json";

if (!is_dir($folder)) {
  mkdir($folder, 0777, true);
}

$assenze = [];

if (file_exists($file)) {
  $contenuto = file_get_contents($file);
  $assenze = json_decode($contenuto, true);
  if (!is_array($assenze)) $assenze = [];
}

$assenze[] = [
  "Data" => $dataCorrente,
  "Orario" => $orario,
  "Tipo" => $tipo
];

file_put_contents($file, json_encode($assenze, JSON_PRETTY_PRINT));

echo json_encode(['success' => true]);
