<?php
if(!isset($_GET['canale']) || !isset($_GET['video'])) {
    echo "Canale o video non specificato.";
    exit;
}

$canale = $_GET['canale'];
$video = $_GET['video'];

$canale_safe = htmlspecialchars($canale);
$video_safe = htmlspecialchars($video);

// Rimuovi .mp4 dal titolo
$video_title = preg_replace('/\.mp4$/i', '', $video_safe);

// Percorso del video
$videoPath = "users/$canale/$video";
if(!file_exists($videoPath)) {
    echo "Video non trovato.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<title><?php echo $video_title; ?> - <?php echo $canale_safe; ?></title>
<style>
body { font-family: Arial; margin:0; background:#f5f5f5; display:flex; flex-direction:column; align-items:center; }
header { display:flex; align-items:center; background:#90ee90; padding:10px 20px; width:100%; box-sizing:border-box; overflow:hidden; }
header img { width:40px; height:40px; margin-right:10px; flex-shrink:0; }
header h1 { margin:0; font-size:20px; margin-right:20px; white-space:nowrap; }
.header-btn { padding:6px 12px; border:none; border-radius:10px; background:white; cursor:pointer; }
.header-btn:hover { background:#eee; }

.video-container { margin-top:20px; width:80%; max-width:800px; position:relative; }
#player { width:100%; border-radius:10px; background:black; display:block; }

/* Controlli custom sovrapposti al video */
.controls-overlay { 
    position:absolute; bottom:10px; left:0; width:100%; display:flex; justify-content:center; align-items:center; gap:10px; 
    background: rgba(0,0,0,0.3); padding:5px 10px; border-radius:5px; box-sizing:border-box;
    transition: opacity 0.3s; opacity:1;
}
.controls-overlay.hidden { opacity:0; pointer-events:none; }

.controls-overlay button, .controls-overlay input[type=range] {
    color:white; background: rgba(255,255,255,0.2); border:none; border-radius:5px; cursor:pointer;
}
.controls-overlay button:hover { background: rgba(255,255,255,0.5); }
.controls-overlay input[type=range] { -webkit-appearance:none; width:150px; height:5px; background:rgba(255,255,255,0.5); }
.controls-overlay input[type=range]::-webkit-slider-thumb { -webkit-appearance:none; width:12px; height:12px; border-radius:50%; background:white; cursor:pointer; }

.video-title { text-align:center; font-size:24px; margin-top:10px; color:#333; }
.time-display { font-size:12px; color:white; margin-left:5px; }
</style>
</head>
<body>

<header>
    <img src="tube.jpg" alt="Logo">
    <h1>PipTube</h1>
    <button class="header-btn" onclick="location.href='canale.php?canale=<?php echo urlencode($canale); ?>'">Torna al canale</button>
</header>

<div class="video-container" id="videoContainer">
    <video id="player">
        <source src="<?php echo htmlspecialchars($videoPath); ?>" type="video/mp4">
        Il tuo browser non supporta il video.
    </video>
    <div class="controls-overlay" id="controlsOverlay">
        <button id="playPause">▶</button>
        <input type="range" id="seekBar" value="0" min="0">
        <span class="time-display" id="timeDisplay">0:00 / 0:00</span>
        <label style="color:white;">Vol</label>
        <input type="range" id="volumeBar" min="0" max="1" step="0.05" value="1">
    </div>
</div>

<div class="video-title"><?php echo $video_title; ?></div>

<script>
const player = document.getElementById('player');
const playPauseBtn = document.getElementById('playPause');
const seekBar = document.getElementById('seekBar');
const volumeBar = document.getElementById('volumeBar');
const timeDisplay = document.getElementById('timeDisplay');
const controlsOverlay = document.getElementById('controlsOverlay');
const videoContainer = document.getElementById('videoContainer');

let hideTimeout;

// Formatta i secondi in mm:ss
function formatTime(seconds) {
    const m = Math.floor(seconds/60);
    const s = Math.floor(seconds%60);
    return m + ':' + (s<10 ? '0'+s : s);
}

// Play/Pause
function togglePlayPause() {
    if(player.paused) {
        player.play();
        playPauseBtn.textContent = '⏸';
    } else {
        player.pause();
        playPauseBtn.textContent = '▶';
    }
}
playPauseBtn.addEventListener('click', togglePlayPause);

// Aggiorna barra progresso e tempo
player.addEventListener('timeupdate', () => {
    seekBar.value = player.currentTime;
    timeDisplay.textContent = formatTime(player.currentTime) + ' / ' + formatTime(player.duration || 0);
});
player.addEventListener('loadedmetadata', () => {
    seekBar.max = player.duration;
    timeDisplay.textContent = formatTime(0) + ' / ' + formatTime(player.duration);
});

// Barra progresso
seekBar.addEventListener('input', () => {
    player.currentTime = seekBar.value;
});

// Volume
volumeBar.addEventListener('input', () => {
    player.volume = volumeBar.value;
});

// Tasti K e Space per play/pause
document.addEventListener('keydown', (e) => {
    if(e.code === 'KeyK' || e.code === 'Space') {
        e.preventDefault();
        togglePlayPause();
    }
});

// Mostra/nascondi controlli come YouTube
function showControls() {
    controlsOverlay.classList.remove('hidden');
    clearTimeout(hideTimeout);
    hideTimeout = setTimeout(() => {
        controlsOverlay.classList.add('hidden');
    }, 3000); // scompare dopo 3 secondi
}

// Mostra i controlli quando muovi il mouse sul video
videoContainer.addEventListener('mousemove', showControls);

// Inizialmente mostra controlli
showControls();
</script>

</body>
</html>
