<?php
if (isset($_GET['user']) && isset($_FILES['video']) && !empty($_FILES['video']['name'])) {
    $user = htmlspecialchars($_GET['user']);
    $uploadDir = "users/" . $user . "/";

    // Gestisci il file caricato
    $videoFile = $_FILES['video'];
    $fileName = basename($videoFile['name']);
    $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    // Verifica che sia un file MP4
    if ($fileExtension !== "mp4") {
        echo "<h3>Errore: È possibile caricare solo file MP4.</h3>";
        exit;
    }

    // Percorso finale del file
    $targetFilePath = $uploadDir . $fileName;

    // Crea la cartella dell'utente se non esiste
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true); // Permessi per la cartella
    }

    // Sposta il file nella cartella dell'utente
    if (move_uploaded_file($videoFile['tmp_name'], $targetFilePath)) {
        // Aggiungi il nome del file alla filelist.txt
        $fileListPath = $uploadDir . "filelist.txt";
        if (!file_exists($fileListPath)) {
            file_put_contents($fileListPath, ""); // Crea un file vuoto se non esiste
        }
        $fileName = trim(basename($videoFile['name']));
        file_put_contents($fileListPath, $fileName . PHP_EOL, FILE_APPEND);

        echo "<h3>Video caricato con successo!</h3>";
    } else {
        echo "<h3>Errore durante il caricamento del video.</h3>";
    }
} else {
    echo "<h3>Errore: Utente o file non specificato. Assicurati di aggiungere il parametro ?user=nomeutente nell'URL.</h3>";
}
?>
