<?php
// Leggi gli utenti dai file
$users = file("users.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$descriptions = file("descriptions.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
?>

<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<title>PipTube</title>
<style>
body { font-family: Arial; margin:0; background:#f5f5f5; }
header { display:flex; align-items:center; background:#90ee90; padding:5px 20px; height:60px; } /* altezza ridotta */
header img { width:40px; height:40px; margin-right:10px; }
header h1 { margin:0; font-size:20px; margin-right:20px; }

.search-bar { position:relative; flex-grow:1; max-width:300px; } /* non occupa tutta la barra */
.search-bar input { width:100%; padding:6px 12px; font-size:14px; border-radius:15px; border:1px solid #ccc; } /* arrotondata */
.suggestions { position:absolute; top:36px; left:0; width:100%; background:white; border:1px solid #ccc; border-radius:5px; max-height:200px; overflow-y:auto; z-index:1000; }
.suggestion-item { padding:8px 12px; cursor:pointer; }
.suggestion-item:hover { background:#eee; }

.channels { display:flex; flex-wrap:wrap; justify-content:center; gap:20px; padding:20px; }
.channel-box { background:white; border-radius:10px; width:250px; padding:15px; box-shadow:0 0 5px rgba(0,0,0,0.2); text-align:center; }
.channel-box img { width:100px; height:100px; border-radius:50%; }
.channel-box h2 { margin:10px 0 5px 0; font-size:20px; }
.channel-box p { font-size:14px; color:#555; min-height:40px; }
.channel-box button { margin-top:10px; padding:10px 15px; font-size:14px; border:none; border-radius:5px; background:#90ee90; cursor:pointer; }
.channel-box button:hover { background:#77dd77; }
</style>
</head>
<body>

<header>
    <img src="tube.jpg" alt="Logo">
    <h1>PipTube</h1>
    <div class="search-bar">
        <input type="text" id="searchInput" placeholder="Cerca un canale..." onkeyup="showSuggestions()">
        <div class="suggestions" id="suggestions" style="display:none;"></div>
    </div>
</header>

<div class="channels" id="channelsContainer">
    <?php
    for ($i=0;$i<count($users);$i++){
        $user = htmlspecialchars($users[$i]);
        $desc = isset($descriptions[$i]) ? htmlspecialchars($descriptions[$i]) : "";
        echo "<div class='channel-box'>";
        echo "<img src='users/$user/profilo.png' alt='$user'>";
        echo "<h2>$user</h2>";
        echo "<p>$desc</p>";
        echo "<button onclick=\"location.href='canale.php?canale=".urlencode($user)."'\">Guarda il canale</button>";
        echo "</div>";
    }
    ?>
</div>

<script>
// Lista canali per l'autocomplete
const users = <?php echo json_encode($users); ?>;

function showSuggestions() {
    const input = document.getElementById("searchInput").value.toLowerCase();
    const suggestions = document.getElementById("suggestions");
    suggestions.innerHTML = '';
    if (input === '') {
        suggestions.style.display = 'none';
        return;
    }

    const matches = users.filter(u => u.toLowerCase().includes(input));
    matches.forEach(u => {
        const div = document.createElement('div');
        div.className = 'suggestion-item';
        div.textContent = u;
        div.onclick = () => { 
            window.location.href = 'canale.php?canale=' + encodeURIComponent(u);
        };
        suggestions.appendChild(div);
    });

    suggestions.style.display = matches.length ? 'block' : 'none';
}

// Nascondi suggerimenti cliccando fuori
document.addEventListener('click', function(e){
    if(!document.querySelector('header').contains(e.target)){
        document.getElementById('suggestions').style.display = 'none';
    }
});
</script>

</body>
</html>
