<?php
if(!isset($_GET['canale'])) {
    echo "Canale non specificato.";
    exit;
}

$canale = $_GET['canale'];
$canale_safe = htmlspecialchars($canale);

// Leggi lista video
$videoFile = "users/$canale/filelist.txt";
$videos = [];
if(file_exists($videoFile)) {
    $videos = file($videoFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<title><?php echo $canale_safe; ?> - PipTube</title>
<style>
body { font-family: Arial; margin:0; background:#f5f5f5; }
header { display:flex; align-items:center; background:#90ee90; padding:5px 20px; height:60px; }
header img { width:40px; height:40px; margin-right:10px; }
header h1 { margin:0; font-size:20px; margin-right:20px; }
header .home-btn { margin-right:20px; padding:6px 12px; border:none; border-radius:10px; background:white; cursor:pointer; }
header .home-btn:hover { background:#eee; }

.search-bar { position:relative; flex-grow:1; max-width:300px; }
.search-bar input { width:100%; padding:6px 12px; font-size:14px; border-radius:15px; border:1px solid #ccc; }
.suggestions { position:absolute; top:36px; left:0; width:100%; background:white; border:1px solid #ccc; border-radius:5px; max-height:200px; overflow-y:auto; z-index:1000; }
.suggestion-item { padding:8px 12px; cursor:pointer; }
.suggestion-item:hover { background:#eee; }

.channel-name { text-align:center; font-size:24px; margin:20px 0; }

.videos { display:flex; flex-wrap:wrap; justify-content:center; gap:20px; padding:20px; }
.video-box { background:white; border-radius:10px; width:250px; padding:15px; box-shadow:0 0 5px rgba(0,0,0,0.2); text-align:center; }
.video-box h2 { font-size:18px; margin:10px 0; }
.video-box button { margin-top:10px; padding:10px 15px; font-size:14px; border:none; border-radius:5px; background:#90ee90; cursor:pointer; }
.video-box button:hover { background:#77dd77; }
</style>
</head>
<body>

<header>
    <img src="tube.jpg" alt="Logo">
    <h1>PipTube</h1>
    <button class="home-btn" onclick="location.href='index.php'">Home</button>
    <div class="search-bar">
        <input type="text" id="searchInput" placeholder="Cerca un video..." onkeyup="filterVideos()">
        <div class="suggestions" id="suggestions" style="display:none;"></div>
    </div>
</header>

<div class="channel-name"><?php echo $canale_safe; ?></div>

<div class="videos" id="videosContainer">
    <?php
    foreach($videos as $video){
        $video_safe = htmlspecialchars($video);
        echo "<div class='video-box'>";
        echo "<h2>$video_safe</h2>";
        echo "<button onclick=\"location.href='video.php?canale=".urlencode($canale)."&video=".urlencode($video)."'\">
                Guarda video
              </button>";
        echo "</div>";
    }
    ?>
</div>

<script>
// Lista video per ricerca dinamica
const videos = <?php echo json_encode($videos); ?>;

function filterVideos(){
    const input = document.getElementById('searchInput').value.toLowerCase();
    const container = document.getElementById('videosContainer');
    const boxes = container.getElementsByClassName('video-box');
    for(let i=0;i<boxes.length;i++){
        const title = boxes[i].querySelector('h2').textContent.toLowerCase();
        boxes[i].style.display = title.includes(input) ? '' : 'none';
    }

    // Mostra suggerimenti sotto la barra
    const suggestions = document.getElementById('suggestions');
    suggestions.innerHTML = '';
    if(input === '') { suggestions.style.display = 'none'; return; }

    const matches = videos.filter(v => v.toLowerCase().includes(input));
    matches.forEach(v=>{
        const div = document.createElement('div');
        div.className = 'suggestion-item';
        div.textContent = v;
        div.onclick = ()=>{ 
            window.location.href = 'video.php?canale=' + encodeURIComponent('<?php echo $canale; ?>') + '&video=' + encodeURIComponent(v);
        };
        suggestions.appendChild(div);
    });
    suggestions.style.display = matches.length ? 'block' : 'none';
}

// Nascondi suggerimenti cliccando fuori
document.addEventListener('click', function(e){
    if(!document.querySelector('header').contains(e.target)){
        document.getElementById('suggestions').style.display = 'none';
    }
});
</script>

</body>
</html>

