<?php
$baseDir = realpath(""); // cartella base del tuo sito (sicura)
$cartella = isset($_GET['Cartella']) ? $_GET['Cartella'] : '';
$path = realpath($baseDir . '/' . $cartella);

if (strpos($path, $baseDir) !== 0 || !is_dir($path)) {
    die("Percorso non valido.");
}

$items = scandir($path);

function encodePath($path) {
    return urlencode(str_replace('\\', '/', $path));
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Augu Cloud – File Manager</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(to right, #004080, #3399ff);
            color: #fff;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 800px;
            margin: 40px auto;
            background-color: #ffffff;
            color: #000;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.2);
        }
        h1 {
            text-align: center;
            color: #004080;
        }
        a {
            color: #004080;
            text-decoration: none;
            font-weight: bold;
        }
        .box {
            border: 1px solid #ccc;
            margin-bottom: 10px;
            padding: 10px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            background-color: #f2f2f2;
            border-radius: 5px;
        }
        .box img {
            margin-right: 10px;
        }
        .box span {
            flex-grow: 1;
            font-weight: bold;
        }
        .actions button {
            margin-left: 5px;
            background-color: #004080;
            color: #fff;
            border: none;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
        }
        .actions button:hover {
            background-color: #003060;
        }
        input[type="text"] {
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        form {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Augu Cloud</h1>
        <h2>Contenuto di: /<?= htmlspecialchars($cartella) ?></h2>

        <?php if ($cartella): ?>
            <a href="?Cartella=<?= urlencode(dirname($cartella)) ?>">⬅️ Indietro</a>
        <?php endif; ?>
        <br><br>

        <form method="post">
            <input type="text" name="nome_nuova_cartella" placeholder="Nome nuova cartella" required>
            <button type="submit" name="crea_cartella">Crea Cartella</button>
        </form>

        <?php
        if (isset($_POST['crea_cartella'])) {
            $nuovo = basename($_POST['nome_nuova_cartella']);
            mkdir($path . '/' . $nuovo);
            header("Location: ?Cartella=" . urlencode($cartella));
            exit;
        }

        if (isset($_POST['rinomina'])) {
            rename($path . '/' . $_POST['vecchio_nome'], $path . '/' . $_POST['nuovo_nome']);
            header("Location: ?Cartella=" . urlencode($cartella));
            exit;
        }

        if (isset($_POST['cancella'])) {
            $da_cancellare = $path . '/' . $_POST['nome'];
            if (is_dir($da_cancellare)) {
                rmdir($da_cancellare);
            } else {
                unlink($da_cancellare);
            }
            header("Location: ?Cartella=" . urlencode($cartella));
            exit;
        }

        foreach ($items as $item) {
            if ($item === '.' || $item === '..') continue;
            $fullPath = $path . '/' . $item;
            $isDir = is_dir($fullPath);
            $relPath = trim($cartella . '/' . $item, '/');
            $icon = $isDir ? 'cartella.png' : 'file.png';

            echo "<div class='box'>
                    <img src='$icon' width='24'>
                    <span>" . htmlspecialchars($item) . "</span>
                    <div class='actions'>";
            if ($isDir) {
                echo "<a href='?Cartella=" . encodePath($relPath) . "'><button>Apri</button></a>";
            }
            echo "<form method='post' style='display:inline'>
                        <input type='hidden' name='vecchio_nome' value='" . htmlspecialchars($item) . "'>
                        <input type='text' name='nuovo_nome' placeholder='Nuovo nome' required>
                        <button type='submit' name='rinomina'>Rinomina</button>
                    </form>
                    <form method='post' style='display:inline'>
                        <input type='hidden' name='nome' value='" . htmlspecialchars($item) . "'>
                        <button type='submit' name='cancella'>Cancella</button>
                    </form>
                </div>
            </div>";
        }
        ?>
    </div>
</body>
</html>
