<?php
header('Content-Type: application/json');

// Recupera l'utenza e la cartella dalla query string
$utenza = $_GET['utenza'] ?? '';
$cartella = $_GET['cartella'] ?? '';

// Verifica se l'utenza è valida e se la directory esiste
if (!$utenza || !is_dir(__DIR__ . "/$utenza")) {
    echo json_encode(["errore" => "Utenza non valida."]);
    exit;
}

// Imposta la directory base per l'utenza
$base = realpath(__DIR__ . "/$utenza");

// Se è stata specificata una cartella, costruisci il percorso relativo
if ($cartella) {
    $dir = realpath($base . "/" . $cartella);
} else {
    // Altrimenti, esplora la cartella principale dell'utenza
    $dir = $base;
}

// Verifica se la cartella esiste
if (!is_dir($dir)) {
    echo json_encode(["errore" => "Cartella non trovata."]);
    exit;
}

// Funzione per trovare solo i file e mostrare solo il nome
function trovaFile($dir) {
    $fileArray = [];
    foreach (scandir($dir) as $voce) {
        if ($voce === '.' || $voce === '..') continue;
        $percorso = "$dir/$voce";
        
        // Aggiungi solo i file, escludendo le cartelle
        if (is_file($percorso)) {
            $fileArray[] = $voce; // Aggiungi solo il nome del file
        }
        // Se è una cartella, esplora ricorsivamente solo i file all'interno
        elseif (is_dir($percorso)) {
            $fileArray = array_merge($fileArray, trovaFile($percorso));
        }
    }
    return $fileArray;
}

// Ottieni la lista dei file
$fileArray = trovaFile($dir);

// Restituisci solo i file come JSON
echo json_encode($fileArray);
?>
