<?php
header('Content-Type: application/json');

$utenza = $_GET['utenza'] ?? '';

if (!$utenza || !is_dir(__DIR__ . "/$utenza")) {
    echo json_encode(["errore" => "Utenza non valida."]);
    exit;
}

$base = realpath(__DIR__ . "/$utenza");

function trovaCartelle($dir, $base) {
    $cartelle = [];
    foreach (scandir($dir) as $voce) {
        if ($voce === '.' || $voce === '..') continue;
        $percorso = "$dir/$voce";
        if (is_dir($percorso)) {
            $relativo = ltrim(str_replace($base, '', $percorso), '/\\');
            $cartelle[] = $relativo;
            $cartelle = array_merge($cartelle, trovaCartelle($percorso, $base));
        }
    }
    return $cartelle;
}

$cartelle = trovaCartelle($base, $base);
echo json_encode($cartelle);
