<?php
require 'GoogleAuthenticator.php'; // singolo file PHP

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    // --- Controllo utenti bannati ---
    $bannedFile = 'bannatip.txt';
    if (file_exists($bannedFile)) {
        $bannedUsers = file($bannedFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        if (in_array($username, $bannedUsers)) {
            die("Accesso negato: sei stato bannato.");
        }
    }

    // --- Verifica credenziali ---
    $userFile = 'nomeutentep.txt';
    $passwordFile = 'Passp.txt';

    if (!file_exists($userFile) || !file_exists($passwordFile)) {
        die("Errore: File delle credenziali non trovato.");
    }

    $users = file($userFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $passwords = file($passwordFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    $userIndex = array_search($username, $users);

    if ($userIndex === false || !isset($passwords[$userIndex]) || $passwords[$userIndex] !== $password) {
        die("Credenziali non valide.");
    }

    // --- Controllo TOTP ---
    $totpFile = 'totp_segreti.txt';
    $totpSecret = null;
    if (file_exists($totpFile)) {
        $lines = file($totpFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            list($user, $secret) = explode(':', $line);
            if ($user === $username) {
                $totpSecret = $secret;
                break;
            }
        }
    }

    // Se TOTP attivo, mostra form di verifica
    if ($totpSecret && empty($_POST['totp_code'])) {
        echo '<form method="POST">';
        echo '<input type="hidden" name="username" value="'.htmlspecialchars($username).'">';
        echo '<input type="hidden" name="password" value="'.htmlspecialchars($password).'">';
        echo '<label>Codice TOTP:</label>';
        echo '<input type="text" name="totp_code" maxlength="6" required>';
        echo '<button type="submit">Verifica</button>';
        echo '</form>';
        exit;
    }

    // --- Se TOTP fornito, verifica ---
    if ($totpSecret && !empty($_POST['totp_code'])) {
        $ga = new PHPGangsta_GoogleAuthenticator();
        $totpCode = trim($_POST['totp_code']);

        if (!$ga->verifyCode($totpSecret, $totpCode, 2)) { // tolleranza ±2 intervalli
            die("Codice TOTP non valido.");
        }
    }

    // --- Login riuscito ---
    $codiceFile = 'codice.txt';
    if (!file_exists($codiceFile)) die("Errore: codice di sessione non trovato.");
    $codiceSessione = trim(file_get_contents($codiceFile));
    header("Location: 3dshome.php?username=" . urlencode($username) . "&session=" . urlencode($codiceSessione));
    exit;

} else {
    echo "Metodo non supportato.";
}
?>
