<?php 
// Controllo sessione
$sessione_url = $_GET['session'] ?? '';
$username = $_GET['username'] ?? '';

$percorso_file = 'codice.txt';
$codice_corrente = trim(file_get_contents($percorso_file));

if ($sessione_url !== $codice_corrente) {
    header("Location: 3dsblocco.html");
    exit;
}

// Genera nuovo codice
$caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
$nuovo_codice = substr(str_shuffle(str_repeat($caratteri, 15)), 0, 15);
file_put_contents($percorso_file, $nuovo_codice);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Citraverse</title>
<style>
/* Corpo pagina */
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
    background: #f0f0f0;
}

/* Header con logo e nome account */
.header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    background: #fff;
    padding: 8px 10px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

.logo-header {
    width: 30px;
    height: 30px;
    margin-right: 8px;
}

.titolo {
    font-size: 18px;
    color: orangered;
    margin: 0;
}

.user-info {
    font-size: 14px;
    font-weight: bold;
}

/* Lista community */
.community-list {
    padding: 10px;
    max-width: 100%;
}

.community-item {
    display: flex;
    align-items: center;
    padding: 8px 0;
}

.community-item img {
    width: 30px;
    height: 30px;
    margin-right: 10px;
}

.community-item a {
    font-size: 14px;
    text-decoration: none;
    color: #333;
}

.community-item a:hover {
    color: orangered;
}

/* Separatore grigio */
.separator {
    height: 1px;
    background: #ccc;
    margin: 5px 0;
}

/* Barra sotto sempre visibile */
.bottom-bar {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #fff;
    display: flex;
    justify-content: space-around;
    border-top: 1px solid #ccc;
    padding: 5px 0;
    box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
}

.bottom-bar a {
    font-size: 12px;
    color: #333;
    text-decoration: none;
}

.bottom-bar a:hover {
    color: orangered;
}

/* Barra sotto tipo separatore */
.bottom-bar {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: #fff;
    display: flex;
    justify-content: center;
    align-items: center;
    border-top: 1px solid #ccc;
    padding: 2px 0;          /* ridotto */
    font-size: 10px;         /* leggermente più piccolo */
    box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
    flex-wrap: nowrap;       /* niente a capo */
    overflow-x: auto;        /* scroll orizzontale solo se strettissimo */
}

.bottom-bar a {
    color: #333;
    text-decoration: none;
    padding: 0 3px;          /* ridotto */
    white-space: nowrap;      /* forza tutto su una riga */
}

.bottom-bar a:hover {
    color: orangered;
}

.bar-separator {
    color: #ccc;
    padding: 0 3px;          /* ridotto */
}


</style>
</head>
<body>

<div class="header">
    <div class="logo-title">
        <img src="citra.jpg" class="logo-header" alt="Logo">
        <span class="titolo">Citraverse</span>
    </div>
    <div class="user-info"><?php echo htmlspecialchars($username); ?></div>
</div>

<div class="community-list">
    <?php
    $pagine = [
        "Tomodachi life" => "3dscommunity.php?community=TOMODACHI",
        "Splatoon" => "3dscommunity.php?community=SPLATOON",
        "Animal crossing" => "3dscommunity.php?community=ANIMAL",
        "Codici amico" => "3dscommunity.php?community=MARIOK",
        "Smash Bros" => "3dscommunity.php?community=SMASH",
        "Mario kart 7" => "3dscommunity.php?community=MARIOK",
        "Pokemon ultrasole" => "3dscommunity.php?community=POKEMONUS",
        "Super mario 3dland" => "3dscommunity.php?community=SUPERM",
        "Avvisi" => "3dsavvisi.php"
    ];

    $immagini = [
        "Tomodachi life" => "tomodachi.jpg",
        "Splatoon" => "splatoon.png",
        "Animal crossing" => "animal.png",
        "Codici amico" => "friends.jpg",
        "Smash Bros" => "Smas.png",
        "Mario kart 7" => "kart.jpg",
        "Pokemon ultrasole" => "pokemon.png",
        "Super mario 3dland" => "Mario.png",
        "Avvisi" => "avvi.png"
    ];

    foreach ($pagine as $nome => $link) {
        $img = $immagini[$nome];
        $href = $link . '&username=' . urlencode($username) . '&session=' . urlencode($nuovo_codice);
        echo <<<HTML
        <div class="community-item">
            <img src="$img" alt="$nome">
            <a href="$href">$nome</a>
        </div>
        <div class="separator"></div>
        HTML;
    }
    ?>
</div>

<!-- Barra sotto sempre visibile -->
<div class="bottom-bar">
    <a href="3dsregolamento.html?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovo_codice); ?>">Regolamento</a>
    <span class="bar-separator">|</span>
    <a href="3dsutente.php?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovo_codice); ?>">Il tuo account</a>
    <span class="bar-separator">|</span>
    <a href="3dshomeen.php?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovo_codice); ?>">English</a>
    <span class="bar-separator">|</span>
    <a href="3dsindex.html">Esci</a>
</div>


</body>
</html>

