<?php 
// Controllo sessione
$sessione_url = $_GET['session'] ?? '';
$username = $_GET['username'] ?? '';

$percorso_file = 'codice.txt';
$codice_corrente = trim(file_get_contents($percorso_file));

if ($sessione_url !== $codice_corrente) {
    header("Location: blocco.html");
    exit;
}

// Genera nuovo codice
$caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
$nuovo_codice = substr(str_shuffle(str_repeat($caratteri, 15)), 0, 15);
file_put_contents($percorso_file, $nuovo_codice);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Citraverse</title>
    <link href="stile30u.css" rel="stylesheet">
</head>
<body>
    <div class="header">
        <div class="logo-title">
            <img src="citra.jpg" alt="Logo" class="logo-header"/>
            <h1 class="titolo">Citraverse</h1>
            <!-- Pulsante Home -->
            <a href="home.php?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovo_codice); ?>" 
               class="home-button">Home</a>
        </div>
        <div class="user-info">
            <?php echo htmlspecialchars($username); ?>
        </div>
    </div>

    <div class="box">
        <div id="comuni">
            <?php
            // Array delle community e link
            $pagine = [
                "Cambia password" => "password.php",
                "Cambia immagine profilo" => "immagine.php",
                "Attiva TOTP" => "totpver.php"
            ];

            // Logo delle community
            $immagini = [
                "Cambia password" => "pasw.png",
                "Cambia immagine profilo" => "imgp.png",
                "Attiva TOTP" => "topti.png"
            ];

            // Generazione dinamica delle card (SOLO logo + nome)
            foreach ($pagine as $nome => $link) {
                $img = $immagini[$nome];
                $href = $link . '?username=' . urlencode($username) . '&session=' . urlencode($nuovo_codice);

                echo <<<HTML
                <div class="community-card" data-nome="$nome">
                    <div class="community-content">
                        <img src="$img" alt="$nome" class="community-logo"/>
                        <a href="$href" class="community-name">$nome</a>
                    </div>
                </div>
                HTML;
            }
            ?>
        </div>
    </div>
</body>
</html>
