<?php
require 'GoogleAuthenticator.php';

// --- HEADER DI SICUREZZA ---
function generaCodiceCasuale($lunghezza = 15) {
    $caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $codice = '';
    for ($i = 0; $i < $lunghezza; $i++) {
        $codice .= $caratteri[random_int(0, strlen($caratteri) - 1)];
    }
    return $codice;
}

$codiceFile = 'codice.txt';
$codiceCorrente = trim(file_get_contents($codiceFile));
$session = $_GET['session'] ?? '';

if ($session === $codiceCorrente) {
    $nuovoCodice = generaCodiceCasuale();
    file_put_contents($codiceFile, $nuovoCodice);
} else {
    header('Location: blocco.html');
    exit;
}

$username = $_GET['username'] ?? '';
$msg = "";

// --- LOGICA TOTP ---
$ga = new PHPGangsta_GoogleAuthenticator();
$totpFile = 'totp_segreti.txt';

// Recupera chiave esistente o crea nuova
$totpSecret = null;
$lines = file_exists($totpFile) ? file($totpFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
foreach ($lines as $line) {
    list($user, $secret) = explode(':', $line);
    if ($user === $username) {
        $totpSecret = $secret;
        break;
    }
}

// Se non esiste la chiave, la creo e salvo subito
if (!$totpSecret) {
    $totpSecret = $ga->createSecret();
    file_put_contents($totpFile, "$username:$totpSecret\n", FILE_APPEND);
}

// Gestione submit TOTP
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userCode = trim($_POST['totp_code'] ?? '');
    
    if ($ga->verifyCode($totpSecret, $userCode, 2)) { // tolleranza 2 intervalli
        $msg = "✅ TOTP attivato con successo!";
    } else {
        $msg = "❌ Codice TOTP non corretto, riprova.";
    }
}

// Genera QR code sempre con la chiave salvata
$qrCodeUrl = $ga->getQRCodeGoogleUrl($username.'@Citraverse', $totpSecret, 'Citraverse');
?>

<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<title>Citraverse - Attiva TOTP</title>
<link rel="stylesheet" href="stile2.css">
<style>
body {
    font-family: Arial, sans-serif;
    background-color: #f5f5f5;
    margin: 0;
    padding: 0;
}
.topbar {
    background-color: white;
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 10px 20px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}
.topbar img { height: 40px; }
.topbar h1 { margin: 0; font-size: 24px; color: black; }
.topbar a.button {
    text-decoration: none;
    color: white;
    background-color: orangered;
    padding: 8px 15px;
    border-radius: 5px;
    font-weight: bold;
}
.container {
    max-width: 450px;
    margin: 40px auto;
    background-color: white;
    padding: 30px;
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    text-align: center;
}
.container input[name="totp_code"] {
    padding: 10px;
    width: 90%;
    border-radius: 5px;
    border: 1px solid #ccc;
    margin-bottom: 15px;
    font-size: 16px;
}
button[type="submit"] {
    padding: 10px 20px;
    background-color: orangered;
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    transition: background-color 0.3s ease;
}
button[type="submit"]:hover {
    background-color: darkorange;
}
.msg { margin-top: 15px; font-weight: bold; color: black; }
.qr-container img { margin: 15px 0; }
.totp-key { margin-top: 10px; font-family: monospace; font-size: 14px; background-color: #f0f0f0; padding: 5px 10px; border-radius: 5px; display: inline-block; }
</style>
</head>
<body>

<div class="topbar">
    <img src="citra.jpg" alt="Citraverse Logo">
    <h1>Citraverse</h1>
    <a class="button" href="utente.php?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovoCodice); ?>">Annulla</a>
</div>

<div class="container">
    <h2>Utente: <u><?php echo htmlspecialchars($username); ?></u></h2>

    <?php if (!$msg || $msg === "❌ Codice TOTP non corretto, riprova."): ?>
        <p>Scansiona questo QR code o inserisca la chiave installatore dentro la tua app di autenticazione (Twillio authy, Samsung wallet, Google autenticator, ecc...) e faccia una piccola verifica qui sotto. NOTA: Se aveva già attivato il totp in precedenza non rifaccia attivazione</p>
        <div class="qr-container">
            <img src="<?php echo $qrCodeUrl; ?>" alt="QR Code TOTP">
            <div class="totp-key">Chiave TOTP: <?php echo htmlspecialchars($totpSecret); ?></div>
        </div>
        <form method="POST" action="?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovoCodice); ?>">
            <input type="text" name="totp_code" placeholder="Inserisci codice TOTP" required>
            <br>
            <button type="submit">Attiva TOTP</button>
        </form>
    <?php endif; ?>

    <?php if ($msg && $msg !== "❌ Codice TOTP non corretto, riprova."): ?>
        <div class="msg"><?php echo $msg; ?></div>
    <?php endif; ?>
</div>

</body>
</html>
