<?php
function generaCodiceCasuale($lunghezza = 15) {
    $caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $codice = '';
    for ($i = 0; $i < $lunghezza; $i++) {
        $codice .= $caratteri[random_int(0, strlen($caratteri) - 1)];
    }
    return $codice;
}

$codiceFile = 'codice.txt';
$codiceCorrente = trim(file_get_contents($codiceFile));
$session = $_GET['session'] ?? '';

if ($session === $codiceCorrente) {
    $nuovoCodice = generaCodiceCasuale();
    file_put_contents($codiceFile, $nuovoCodice);
} else {
    header('Location: blocco.html');
    exit;
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tomodachi - Citraverse</title>
    <link href="tomodachistile.css" rel="stylesheet">
    <script>
        // Funzione per ricaricare il contenuto della chat
        function refreshChat() {
            const chatFrame = document.getElementById('chatFrame');
            chatFrame.src = 'chatvito.php?' + new Date().getTime(); // Forza il ricaricamento del contenuto
        }

        // Funzione per ricaricare il frame di invio messaggi solo quando il tasto è premuto
        function refreshSendTomo() {
            const sendTomoFrame = document.getElementById('sendTomoFrame');
            const username = getQueryParameter("username"); // Ottieni il nome utente dalla URL
            sendTomoFrame.src = `TOMODACHI/sendtomo.html?username=${encodeURIComponent(username)}`; // Passa il nome utente
        }

        // Funzione per ottenere i parametri dalla URL
        function getQueryParameter(name) {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get(name);
        }

        // Funzione per reindirizzare alla pagina principale con il nome utente
        function goHome() {
    const username = getQueryParameter("username");

    // Recupera il codice da un file PHP
    fetch('codice.txt')
        .then(response => response.text())
        .then(code => {
            const codice = code.trim();
            window.location.href = `home.php?username=${encodeURIComponent(username)}&session=${encodeURIComponent(codice)}`;
        })
        .catch(error => {
            console.error('Errore nel recupero del codice:', error);
            alert('Errore nel caricamento del codice.');
        });
}


        window.onload = function() {
            refreshChat(); // Ricarica la chat automaticamente al caricamento della pagina
        };

        setInterval(refreshChat, 2300); // Ricarica la chat ogni 5 secondi
    </script>
</head>
<body>
    <div class="navbar">
        <button onclick="goHome()">Home</button> <!-- Modificato per usare goHome -->
        <button onclick="refreshSendTomo()">Aggiorna</button> <!-- Nuovo tasto per ricaricare sendtomo.html -->
    </div>
    <h1 class="titolo">Tomodachi life</h1>
    <hr/>

    <div class="box">
        <iframe id="chatFrame" src="TOMODACHI/chatvito.php" class="iframe-box"></iframe>
    </div>

    <div class="box">
        <iframe id="sendTomoFrame" src="apol.html" class="iframe-box"></iframe>
    </div>
</body>
</html>
