<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

if (isset($_POST['invia']) && !empty($_POST['username'])) {
    $username = trim($_POST['username']);

    // Carica la lista utenti da mailp.txt
    $jsonData = file_get_contents("mailp.txt");
    $utenti = json_decode($jsonData, true);

    // Cerca l'utente
    $email = null;
    foreach ($utenti as $u) {
        if (strcasecmp($u['username'], $username) == 0) { // case-insensitive
            $email = $u['email'];
            break;
        }
    }

    if ($email === null) {
        die("⚠️ Nome utente non trovato!");
    }

    // Prime 4 lettere dell'email
    $iniziali = substr($email, 0, 4);

    // Nome file
    $filename = $iniziali . ".txt";

    // Se esiste già, lo elimina
    if (file_exists($filename)) {
        unlink($filename);
    }

    // Genera codice random a 16 caratteri
    $codice = bin2hex(random_bytes(8));

    // Scrive codice nel file
    file_put_contents($filename, $codice);

    // Prepara mail
    $mail = new PHPMailer(true);

    try {
        // Configurazione SMTP Outlook
        $mail->isSMTP();
        $mail->Host       = 'smtp.office365.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'citraverse@outlook.com';   // la tua mail outlook
        $mail->Password   = 'Citra123Verse';       // password o password app
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        // Mittente
        $mail->setFrom('citraverse@outlook.com', 'Il Mio Sito');

        // Destinatario (dal file JSON)
        $mail->addAddress($email);

        // Link personalizzato
        $link = "https://ilmiosito.com?codice=" . $codice;

        // Contenuto
        $mail->isHTML(true);
        $mail->Subject = 'Il tuo link personale';
        $mail->Body    = "Ciao $username! Ecco il tuo link personale: <a href='$link'>$link</a>";

        $mail->send();
        echo "✅ Email inviata a $email<br>";
        echo "📄 Creato file: $filename con codice: $codice";
    } catch (Exception $e) {
        echo "❌ Errore nell'invio: {$mail->ErrorInfo}";
    }
} else {
    echo "⚠️ Nessun nome utente inserito!";
}
