<?php
// --- HEADER DI SICUREZZA ---
function generaCodiceCasuale($lunghezza = 15) {
    $caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $codice = '';
    for ($i = 0; $i < $lunghezza; $i++) {
        $codice .= $caratteri[random_int(0, strlen($caratteri) - 1)];
    }
    return $codice;
}

$codiceFile = 'codice.txt';
$codiceCorrente = trim(file_get_contents($codiceFile));
$session = $_GET['session'] ?? '';

if ($session === $codiceCorrente) {
    $nuovoCodice = generaCodiceCasuale();
    file_put_contents($codiceFile, $nuovoCodice);
} else {
    header('Location: bloccoen.html');
    exit;
}

$username = $_GET['username'] ?? '';
$msg = "";

// --- LOGICA CAMBIO PASSWORD ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nuovaPassword = trim($_POST['nuova_password'] ?? '');

    if ($username !== '' && $nuovaPassword !== '') {
        $utenti = file('nomeutentep.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $pass   = file('Passp.txt', FILE_IGNORE_NEW_LINES);

        $index = false;
        foreach ($utenti as $i => $u) {
            if (trim($u) === trim($username)) {
                $index = $i;
                break;
            }
        }

        if ($index === false) {
            $msg = "❌ User not found";
        } else {
            if (!isset($pass[$index])) {
                for ($j = count($pass); $j <= $index; $j++) {
                    $pass[$j] = '';
                }
            }

            $pass[$index] = $nuovaPassword;
            $contenuto = implode(PHP_EOL, $pass) . PHP_EOL;

            if (file_put_contents('Passp.txt', $contenuto, LOCK_EX) !== false) {
                $msg = "✅ Your password is changed!";
            } else {
                $msg = "❌ Writing error on the password file.";
            }
        }
    } else {
        $msg = "❌ Insert a new password!";
    }
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<title>Citraverse - Change password</title>
<link rel="stylesheet" href="stile2.css">
<style>
.header {
    width: 100%;
    background-color: white;
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 10px 20px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    position: fixed;
    top: 0;
    left: 0;
    z-index: 100;
}

.header img {
    height: 40px;
}

.header .title {
    color: orangered;
    font-size: 24px;
    font-weight: bold;
    text-align: center;
    flex: 1;
}

.button-annulla {
    padding: 8px 16px;
    background-color: orangered;
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    text-decoration: none;
    transition: background-color 0.3s ease;
    white-space: nowrap; /* Non va a capo */
}

.button-annulla:hover {
    background-color: darkorange;
}

.container {
    width: 350px;
    background-color: white;
    border-radius: 10px;
    padding: 30px 20px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    margin: 150px auto 0 auto;
    text-align: center;
}

input[name="nuova_password"] {
    padding: 10px;
    width: 90%;
    border-radius: 5px;
    border: 1px solid #ccc;
    margin-bottom: 15px;
    font-size: 16px;
}

button[type="submit"] {
    padding: 10px 20px;
    background-color: orangered;
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    transition: background-color 0.3s ease;
}

button[type="submit"]:hover {
    background-color: darkorange;
}

.msg {
    margin-top: 15px;
    font-weight: bold;
    color: black;
}

body {
    display: flex;
    justify-content: center;
    align-items: start;
    min-height: 100vh;
    background-image: url('mii.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    font-family: Arial, sans-serif;
    margin: 0;
}
</style>
</head>
<body>
<div class="header">
    <img src="citrao.jpg" alt="Logo">
    <div class="title">Citraverse</div>
    <a id="annulla-button" class="button-annulla" href="#">Cancel</a>
</div>

<div class="container">
    <h2>User: <u><?php echo htmlspecialchars($username); ?></u></h2>
    <form method="POST" action="?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovoCodice); ?>">
        <input type="text" name="nuova_password" placeholder="New password">
        <br>
        <button type="submit">Change</button>
    </form>
    <?php if ($msg): ?>
        <div class="msg"><?php echo $msg; ?></div>
    <?php endif; ?>
</div>

<script>
// Legge il codice direttamente dal file PHP prima di andare a home.php
document.getElementById('annulla-button').addEventListener('click', function(e) {
    e.preventDefault();
    fetch('codice.txt')
        .then(response => response.text())
        .then(codice => {
            const url = `utenteen.php?username=<?php echo urlencode($username); ?>&session=${codice.trim()}`;
            window.location.href = url;
        });
});
</script>
</body>
</html>

