<?php  
function generaCodiceCasuale($lunghezza = 15) {
    $caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $codice = '';
    for ($i = 0; $i < $lunghezza; $i++) {
        $codice .= $caratteri[random_int(0, strlen($caratteri) - 1)];
    }
    return $codice;
}

$codiceFile = 'codice.txt';
$codiceCorrente = trim(file_get_contents($codiceFile));
$session = $_GET['session'] ?? '';
$username = $_GET['username'] ?? '';

if ($session === $codiceCorrente) {
    $nuovoCodice = generaCodiceCasuale();
    file_put_contents($codiceFile, $nuovoCodice);
} else {
    header('Location: blocco.html');
    exit;
}

// gestione caricamento immagine
$messaggio = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['immagine'])) {
    $fileTmp = $_FILES['immagine']['tmp_name'];
    $fileName = $_FILES['immagine']['name'];
    $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if ($ext === "png") {
        $usernameLower = strtolower($username); // SOLO per il file
        $dest = __DIR__ . "/Profili/" . $usernameLower . ".png";
        if (move_uploaded_file($fileTmp, $dest)) {
            $messaggio = "Image saved successfully!";
        } else {
            $messaggio = "Error saving image.";
        }
    } else {
        $messaggio = "Only .png files are accepted!";
    }
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>Citraverse - Profile</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: url("mii.png") no-repeat center center fixed;
            background-size: cover;
        }
        .navbar {
            background-color: rgba(255, 255, 255, 0.8);
            height: 60px;
            display: flex;
            align-items: center;
            padding: 0 20px;
        }
        .navbar img {
            height: 40px;
            margin-right: 15px;
        }
        .navbar h1 {
            flex-grow: 1;
            text-align: center;
            margin: 0;
            color: orangered;
        }
        .navbar a {
            text-decoration: none;
            background-color: orangered;
            color: white;
            padding: 8px 15px;
            border-radius: 5px;
            font-weight: bold;
        }
        .box {
            background-color: white;
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
        }
        .box input[type=file], 
        .box button {
            margin: 15px 0;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            background-color: orangered;
            color: white;
            font-weight: bold;
            cursor: pointer;
        }
        .box button:hover, 
        .box input[type=file]:hover {
            opacity: 0.85;
        }
        .preview {
            margin-top: 15px;
        }
        .preview img {
            max-width: 100px;
            border: 2px solid #ccc;
            border-radius: 5px;
        }
        .messaggio {
            margin-top: 15px;
            font-weight: bold;
            color: green;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <img src="citra.jpg" alt="Citra Logo">
        <h1>Citraverse</h1>
        <a href="utenteen.php?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovoCodice); ?>">Cancel</a>
    </div>

    <div class="box">
        <p>Set a profile photo for your account<br>
        (a 50px by 50px image is recommended)</p>

        <form method="post" enctype="multipart/form-data" 
              action="?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovoCodice); ?>">
            <input type="file" name="immagine" accept=".png" required onchange="previewImage(event)"><br>
            <div class="preview" id="preview"></div>
            <button type="submit">Save</button>
        </form>

        <?php if (!empty($messaggio)): ?>
            <div class="messaggio"><?php echo htmlspecialchars($messaggio); ?></div>
        <?php endif; ?>
    </div>

    <script>
        function previewImage(event) {
            const preview = document.getElementById('preview');
            preview.innerHTML = '';
            const file = event.target.files[0];
            if (file && file.type === "image/png") {
                const img = document.createElement('img');
                img.src = URL.createObjectURL(file);
                preview.appendChild(img);
            }
        }
    </script>
</body>
</html>

