<?php
// Controllo sessione
$sessione_url = $_GET['session'] ?? '';
$username = $_GET['username'] ?? '';

$percorso_file = 'codice.txt';
$codice_corrente = trim(file_get_contents($percorso_file));

if ($sessione_url !== $codice_corrente) {
    header("Location: bloccoen.html");
    exit;
}

// Genera nuovo codice
$caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
$nuovo_codice = substr(str_shuffle(str_repeat($caratteri, 15)), 0, 15);
file_put_contents($percorso_file, $nuovo_codice);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Citraverse</title>
    <link href="stile30.css" rel="stylesheet">
</head>
<body>
    <div class="header">
        <div class="logo-title">
            <img src="citra.jpg" alt="Logo" class="logo-header"/>
            <h1 class="titolo">Citraverse</h1>
            <div class="menu-container">
                <button class="menu-toggle">☰</button>
                <div class="menu-dropdown">
                    <a href="regolamentoen.html?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovo_codice); ?>">Rules</a>
                    <a href="utenteen.php?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovo_codice); ?>">Your profile</a>
                    <a href="home.php?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($nuovo_codice); ?>">Italiano</a>
                    <a href="indexen.html">Log out</a>
                </div>
            </div>
        </div>
        <div class="user-info">
            <?php echo htmlspecialchars($username); ?>
        </div>
    </div>

    <div class="box">
        <!-- Barra di ricerca sopra le community -->
        <input type="text" id="search" placeholder="Search a community...">

        <div id="comuni">
            <?php
            // Array delle community e link
            $pagine = [
                "Tomodachi life" => "communityen.php?community=TOMODACHI",
                "Splatoon" => "communityen.php?community=SPLATOON",
                "Animal crossing" => "communityen.php?community=ANIMAL",
                "Friends code" => "communityen.php?community=FRIENDS",
                "Smash Bros" => "communityen.php?community=SMASH",
                "Mario kart 7" => "communityen.php?community=MARIOK",
                "Pokemon ultrasun" => "communityen.php?community=POKEMONUS",
                "Super mario 3dland" => "communityen.php?community=SUPERM",
                "Notices" => "avvisi.php"
            ];

            // Logo delle community
            $immagini = [
                "Tomodachi life" => "tomodachi.jpg",
                "Splatoon" => "splatoon.png",
                "Animal crossing" => "animal.png",
                "Friends code" => "friends.jpg",
                "Smash Bros" => "Smas.png",
                "Mario kart 7" => "kart.jpg",
                "Pokemon ultrasun" => "pokemon.png",
                "Super mario 3dland" => "Mario.png",
                "Notices" => "avvi.png"
            ];

            // Banner delle community
            $banner = [
                "Tomodachi life" => "banner_tomodachi2.jpg",
                "Splatoon" => "banner_splatoon.jpg",
                "Animal crossing" => "banner_animal.jpg",
                "Friends code" => "banner_friends.jpg",
                "Smash Bros" => "banner_smash.jpg",
                "Mario kart 7" => "banner_kart.png",
                "Pokemon ultrasun" => "banner_pokemon.png",
                "Super mario 3dland" => "banner_mario.jpg",
                "Notices" => "banner_avvi.png"
            ];

            // Generazione dinamica delle card
            foreach ($pagine as $nome => $link) {
                $img = $immagini[$nome];
                $ban = $banner[$nome];
                $href = $link . '&username=' . urlencode($username) . '&session=' . urlencode($nuovo_codice);

                echo <<<HTML
                <div class="community-card" data-nome="$nome">
                    <img src="$ban" alt="Banner $nome" class="community-banner"/>
                    <div class="community-content">
                        <img src="$img" alt="$nome" class="community-logo"/>
                        <a href="$href" class="community-name">$nome</a>
                    </div>
                </div>
                HTML;
            }
            ?>
        </div>
    </div>

    <script>
        // Toggle menu panino
        document.querySelector(".menu-toggle").addEventListener("click", function () {
            document.querySelector(".menu-dropdown").classList.toggle("show");
        });

        // Ricerca community
        document.getElementById("search").addEventListener("input", function () {
            let filter = this.value.toLowerCase();
            document.querySelectorAll(".community-card").forEach(card => {
                card.style.display = card.dataset.nome.toLowerCase().includes(filter) ? "block" : "none";
            });
        });
    </script>
</body>
</html>
