<?php
// Controllo sessione
$sessione_url = $_GET['session'] ?? '';
$username = $_GET['username'] ?? '';

$percorso_file = 'codice.txt';
$codice_corrente = trim(file_get_contents($percorso_file));

if ($sessione_url !== $codice_corrente) {
    header("Location: blocco.html");
    exit;
}

// Genera e salva nuovo codice
$caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
$nuovo_codice = substr(str_shuffle(str_repeat($caratteri, 15)), 0, 15);
file_put_contents($percorso_file, $nuovo_codice);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Citraverse</title>
    <link href="stile2.css" rel="stylesheet">
</head>
<body>
    <div class="header">
        <h1 class="titolo">Citraverse</h1>
        <img src="citra.jpg" alt="Logo"/>
        <button id="logout-button">Esci</button>
    </div>
    <hr/>
    <div id="welcome-message">
        <?php if (!empty($username)) echo "<h2>Benvenuto, " . htmlspecialchars($username) . "!</h2>"; ?>
    </div>
    <div class="box">
        <div id="comuni">
            <?php
            $pagine = [
                "Tomodachi life" => "tomodachi.php",
                "Splatoon" => "splatoon.php",
                "Animal crossing" => "animal.php",
                "Codici amico" => "friends.php",
                "Smash Bros" => "smash.php",
                "Mario kart 7" => "mariokart.php",
                "Pokemon ultrasole" => "pokemonultrasole.php",
                "Super mario 3dland" => "supermario.php",
                "------------------------------------------------" => "home.php",
                "Regolamento" => "regolamento.html",
                "Avvisi" => "avvisi.php",
                "Cambia password" => "password.php",
                "English" => "homeen.php"
            ];
            $immagini = [
                "Tomodachi life" => "tomodachi.jpg",
                "Splatoon" => "splatoon.png",
                "Animal crossing" => "animal.png",
                "Codici amico" => "friends.jpg",
                "Smash Bros" => "Smas.png",
                "Mario kart 7" => "kart.jpg",
                "Pokemon ultrasole" => "pokemon.png",
                "Super mario 3dland" => "Mario.png",
                "------------------------------------------------" => "Bia.jpg",
                "Regolamento" => "rego.png",
                "Avvisi" => "avvi.png",
                "Cambia password" => "pasw.png",
                "English" => "engl.png"
            ];

            foreach ($pagine as $nome => $link) {
                $img = $immagini[$nome];
                $href = strpos($link, '.html') !== false 
                    ? $link . '?username=' . urlencode($username) . '&session=' . urlencode($nuovo_codice)
                    : $link . '?username=' . urlencode($username) . '&session=' . urlencode($nuovo_codice);
                echo <<<HTML
                <div class="item">
                    <a href="$href">$nome</a>
                    <img src="$img" alt="$nome"/>
                </div>
                HTML;
            }
            ?>
        </div>
    </div>

    <script>
        document.getElementById("logout-button").addEventListener("click", function () {
            window.location.href = "index.html";
        });
    </script>
</body>
</html>
