<?php
// Funzione per generare codice casuale
function generaCodiceCasuale($lunghezza = 15) {
    $caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $codice = '';
    for ($i = 0; $i < $lunghezza; $i++) {
        $codice .= $caratteri[random_int(0, strlen($caratteri) - 1)];
    }
    return $codice;
}

// Parametri GET
$session = $_GET['session'] ?? '';
$username = $_GET['username'] ?? 'guest';
$community = $_GET['community'] ?? 'default';

// Legge codice corrente
$codiceFile = 'codice.txt';
$codiceCorrente = trim(file_get_contents($codiceFile));

if ($session !== $codiceCorrente) {
    header('Location: blocco.html');
    exit;
}

// Aggiorna codice
$nuovoCodice = generaCodiceCasuale();
file_put_contents($codiceFile, $nuovoCodice);

// Percorso cartella community e file info
$cartellaCommunity = $community;
$infoFile = $cartellaCommunity . '/informazioni.txt';
$info = file($infoFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

$nome = $info[0] ?? 'Nome Community';
$banner = $info[1] ?? 'banner.jpg';
$logo = $info[2] ?? 'logo.png';
$descrizione = $info[3] ?? 'Descrizione della community';

// Legge session da verifica.txt
$sessionValue = trim(file_get_contents('verifica.txt'));
?>

<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($nome); ?> - Citraverse</title>
<link href="tomodachistile7.css" rel="stylesheet">
</head>
<body>
<div class="navbar">
    <div class="logo-container">
        <img src="citra.jpg" class="logo">
        <span class="site-title">Citraverse</span>
    </div>
    <button class="home-btn" onclick="goHome()">Home</button>
</div>

<div class="main-content">
    <div class="community-box">
        <img src="<?php echo htmlspecialchars($banner); ?>" class="community-banner">
        <div class="community-header">
            <img src="<?php echo htmlspecialchars($logo); ?>" class="community-logo">
            <span class="community-name"><?php echo htmlspecialchars($nome); ?></span>
        </div>
        <div class="community-desc"><?php echo htmlspecialchars($descrizione); ?></div>
        <div class="community-fill"></div>
    </div>

    <div class="right-box">
        <!-- Form nascosti per POST -->
        <form id="chatForm" action="chatvisual6.php" method="post" target="chatFrame">
            <input type="hidden" name="username" value="<?php echo htmlspecialchars($username); ?>">
            <input type="hidden" name="community" value="<?php echo htmlspecialchars($community); ?>">
        </form>
        <iframe id="chatFrame" name="chatFrame" class="iframe-chat" data-last-content=""></iframe>

        <form id="sendForm" action="<?php echo $cartellaCommunity; ?>/sendtomo.php" method="post" target="sendTomoFrame">
            <input type="hidden" name="username" value="<?php echo htmlspecialchars($username); ?>">
            <input type="hidden" name="community" value="<?php echo htmlspecialchars($community); ?>">
            <input type="hidden" name="session" value="<?php echo htmlspecialchars($sessionValue); ?>">
        </form>
        <iframe id="sendTomoFrame" name="sendTomoFrame" class="iframe-send"></iframe>
    </div>
</div>

<script>
// Ricarica i frame via POST
window.onload = function() {
    document.getElementById('chatForm').submit();
    document.getElementById('sendForm').submit();
    setInterval(checkChatUpdate, 1500);
};

// Funzione per aggiornare la chat automaticamente
let isScrolling = false;
function checkChatUpdate() {
    fetch('<?php echo $cartellaCommunity; ?>/tomochat.txt?cache=' + new Date().getTime())
        .then(resp => resp.text())
        .then(text => {
            const chatBox = document.getElementById('chatFrame');
            if (text !== chatBox.dataset.lastContent) {
                if (!isScrolling) {
                    chatBox.contentWindow.location.reload();
                } else {
                    setTimeout(() => { chatBox.contentWindow.location.reload(); }, 500);
                }
                chatBox.dataset.lastContent = text;
            }
        });
}

// Home button
function goHome() {
    const username = "<?php echo $username; ?>";
    fetch('codice.txt')
        .then(response => response.text())
        .then(code => {
            const codice = code.trim();
            window.location.href = `home.php?username=${encodeURIComponent(username)}&session=${encodeURIComponent(codice)}`;
        });
};
</script>
</body>
</html>
