<?php
// Recupera community e username da POST
$community = isset($_POST['community']) ? $_POST['community'] : 'default';
$currentUser = isset($_POST['username']) ? trim($_POST['username']) : '';

// Percorso al file in base al community
$filePath = $community . '/tomochat.txt';

// --- Eliminazione di un post tramite GET ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['deleteLine'])) {
    $deleteLine = (int)$_GET['deleteLine'];
    $lines = file($filePath, FILE_IGNORE_NEW_LINES);
    if ($lines !== false && isset($lines[$deleteLine])) {
        unset($lines[$deleteLine]);
        file_put_contents($filePath, implode("\n", $lines) . "\n");
    }
    // Redirect semplice per ricaricare la pagina senza deleteLine
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

// Leggi tutte le righe del file
$lines = file($filePath, FILE_IGNORE_NEW_LINES);
if ($lines === false) $lines = []; // Se il file non esiste o è vuoto

?>

<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Chat stile Miiverse</title>
<style>
body { font-family: Arial, sans-serif; margin: 0; padding: 0; background-color: transparent; }
.container { width: 99.3%; margin: 0 auto; border-left: 1px solid #ccc; border-right: 1px solid #ccc; }
.box { position: relative; border-bottom: 1px solid #ccc; padding: 10px; display: flex; gap: 10px; }
.box:hover .delete-btn { display: block; }
.utente { width: 50px; flex-shrink: 0; }
.utente img { width: 50px; height: 50px; object-fit: cover; }
.contenuto { flex: 1; display: flex; flex-direction: column; }
.nome { font-weight: bold; font-size: 16px; margin-bottom: 3px; }
.messaggio { font-size: 15px; color: #000; white-space: pre-wrap; }
.immagine-messaggio { margin-top: 5px; max-width: 400px; max-height: 600px; width: auto; height: auto; object-fit: contain; display: block; }
.delete-btn { display: none; position: absolute; top: 5px; right: 5px; background: red; color: white; border: none; border-radius: 50%; width: 24px; height: 24px; cursor: pointer; font-weight: bold; line-height: 20px; text-align: center; }
@media (max-width: 600px) { .container { width: 100%; } .nome { font-size: 14px; } .messaggio { font-size: 14px; } }
</style>
</head>
<body>

<div class="container">

<?php foreach ($lines as $index => $line): ?>
    <?php if (strpos($line, ':') !== false): ?>
        <?php
        list($username, $text) = explode(':', $line, 2);
        $username = trim($username);
        $text = trim($text);

        // Percorso immagine profilo
        $profilePath = "Profili/" . strtolower($username) . ".png";
        if (!file_exists($profilePath)) { $profilePath = "Profili/predefinita.png"; }

        // Gestione immagini nel messaggio
        $imgTags = '';
        if (preg_match_all('/IMG>([^ ]+\.png)/i', $text, $matches)) {
            foreach ($matches[1] as $imgFileName) {
                $imgFile = 'immagini/' . $imgFileName;
                if (file_exists($imgFile)) {
                    $imgTags .= "<img src='".htmlspecialchars($imgFile)."' alt='immagine' class='immagine-messaggio'>";
                }
            }
            $text = preg_replace('/IMG>[^ ]+\.png/i', '', $text);
        }
        ?>
        <div class="box">
            <?php if ($currentUser !== '' && strtolower($currentUser) === strtolower($username)): ?>
                <form method="POST" action="?deleteLine=<?php echo intval($index); ?>" style="margin:0;">
                    <input type="hidden" name="community" value="<?php echo htmlspecialchars($community); ?>">
                    <input type="hidden" name="username" value="<?php echo htmlspecialchars($currentUser); ?>">
                    <button type="submit" class="delete-btn">×</button>
                </form>
            <?php endif; ?>
            <div class="utente">
                <img src="<?php echo htmlspecialchars($profilePath); ?>" alt="pfp">
            </div>
            <div class="contenuto">
                <div class="nome"><?php echo htmlspecialchars($username); ?></div>
                <div class="messaggio"><?php echo htmlspecialchars($text); ?></div>
                <?php echo $imgTags; ?>
            </div>
        </div>
    <?php else: ?>
        <div class="box">
            <div class="messaggio"><?php echo htmlspecialchars($line); ?></div>
        </div>
    <?php endif; ?>
<?php endforeach; ?>

</div>
</body>
</html>
