<?php
// Recupera il parametro dalla query string
$community = isset($_GET['community']) ? $_GET['community'] : 'default';

// Percorso al file in base al community
$filePath = $community . '/tomochat.txt';

// Leggi tutte le righe del file
$lines = file($filePath, FILE_IGNORE_NEW_LINES);

// Controlla se il file è stato letto correttamente
if ($lines === false) {
    die("Errore nella lettura del file: " . htmlspecialchars($filePath));
}
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat stile Miiverse</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: trasparent;
        }
        .container {
            width: 99.3%;
            margin: 0 auto;
            border-left: 1px solid #ccc;
            border-right: 1px solid #ccc;
        }
        .box {
            border-bottom: 1px solid #ccc;
            padding: 10px;
            display: flex;
            gap: 10px;
        }
        .utente {
            width: 50px;
            flex-shrink: 0;
        }
        .utente img {
            width: 50px;
            height: 50px;
            object-fit: cover;
        }
        .contenuto {
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .nome {
            font-weight: bold;
            font-size: 16px;
            margin-bottom: 3px;
        }
        .messaggio {
            font-size: 15px;
            color: #000;
            white-space: pre-wrap;
        }
        .immagine-messaggio {
            margin-top: 5px;
            max-width: 400px;    /* larghezza massima */
            max-height: 600px;   /* altezza massima */
            width: auto;
            height: auto;
            object-fit: contain;  /* mantiene proporzioni */
            display: block;
        }
        @media (max-width: 600px) {
            .container {
                width: 100%;
            }
            .nome {
                font-size: 14px;
            }
            .messaggio {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
<div class="container">
<?php
foreach ($lines as $line) {
    if (strpos($line, ':') !== false) {
        list($username, $text) = explode(':', $line, 2);
        $username = trim($username);
        $text = trim($text);

        // Percorso immagine profilo
        $profilePath = "Profili/" . strtolower($username) . ".png";
        if (!file_exists($profilePath)) {
            $profilePath = "Profili/predefinita.png";
        }

        // Cerca tutte le immagini IMG>qualcosa.png nel messaggio
        $imgTags = '';
        if (preg_match_all('/IMG>([^ ]+\.png)/i', $text, $matches)) {
            foreach ($matches[1] as $imgFileName) {
                $imgFile = 'immagini/' . $imgFileName;
                if (file_exists($imgFile)) {
                    $imgTags .= "<img src='".htmlspecialchars($imgFile)."' alt='immagine' class='immagine-messaggio'>";
                }
            }
            // Rimuove tutte le stringhe IMG> dal testo
            $text = preg_replace('/IMG>[^ ]+\.png/i', '', $text);
        }

        echo "<div class='box'>
                <div class='utente'>
                    <img src='".htmlspecialchars($profilePath)."' alt='pfp'>
                </div>
                <div class='contenuto'>
                    <div class='nome'>".htmlspecialchars($username)."</div>
                    <div class='messaggio'>".htmlspecialchars($text)."</div>
                    $imgTags
                </div>
              </div>";
    } else {
        echo "<div class='box'>
                <div class='messaggio'>".htmlspecialchars($line)."</div>
              </div>";
    }
}
?>
</div>
</body>
</html>


