<?php 
function generaCodiceCasuale($lunghezza = 15) {
    $caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $codice = '';
    for ($i = 0; $i < $lunghezza; $i++) {
        $codice .= $caratteri[random_int(0, strlen($caratteri) - 1)];
    }
    return $codice;
}

$codiceFile = 'codice.txt';
$codiceCorrente = trim(file_get_contents($codiceFile));
$session = $_GET['session'] ?? '';
$username = $_GET['username'] ?? '';

if ($session === $codiceCorrente) {
    $nuovoCodice = generaCodiceCasuale();
    file_put_contents($codiceFile, $nuovoCodice);
} else {
    header('Location: blocco.html');
    exit;
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Avvisi - Citraverse</title>
<link href="tomodachistile7.css" rel="stylesheet">
<script>
let isScrolling = false;

// Scroll nella chat
function startScroll() { isScrolling = true; }
function stopScroll() { isScrolling = false; }

// Controllo aggiornamento chat
function checkChatUpdate() {
    fetch('AVVISI/tomochat.txt?cache=' + new Date().getTime())
        .then(resp => resp.text())
        .then(text => {
            const chatBox = document.getElementById('chatFrame');
            if (text !== chatBox.dataset.lastContent) {
                if (!isScrolling) {
                    chatBox.contentWindow.location.reload();
                } else {
                    setTimeout(() => {
                        chatBox.contentWindow.location.reload();
                    }, 500);
                }
                chatBox.dataset.lastContent = text;
            }
        });
}

// Funzione Home
function goHome() {
    const username = "<?php echo $username; ?>"; // recupera username da PHP
    fetch('codice.txt')
        .then(response => response.text())
        .then(code => {
            const codice = code.trim();
            window.location.href = `home.php?username=${encodeURIComponent(username)}&session=${encodeURIComponent(codice)}`;
        })
        .catch(error => {
            console.error('Errore nel recupero del codice:', error);
            alert('Errore nel caricamento del codice.');
        });
}

// Onload
window.onload = function() {
    setInterval(checkChatUpdate, 1500); // controlla aggiornamenti chat
};
</script>
</head>
<body>
<div class="navbar">
    <div class="logo-container">
        <img src="citra.jpg" class="logo">
        <span class="site-title">Citraverse</span>
    </div>
    <button class="home-btn" onclick="goHome()">Home</button>
</div>

<div class="main-content">
    <!-- Colonna sinistra: community -->
    <div class="community-box">
        <img src="banner_avvi.png" class="community-banner">
        <div class="community-header">
            <img src="avvi.png" class="community-logo">
            <span class="community-name">Avvisi</span>
        </div>
        <div class="community-desc">
            Qua si ricevono avvisi dai amministratori di Citraverse
        </div>
        <div class="community-fill"></div>
    </div>

    <!-- Colonna destra: solo chat -->
    <div class="right-box">
        <iframe id="chatFrame" class="iframe-chat" 
                src="chatvisual6.php?community=AVVISI" 
                onscroll="isScrolling=true; clearTimeout(this.scrollTimeout); this.scrollTimeout=setTimeout(()=>{isScrolling=false;},500);" 
                data-last-content="">
        </iframe>
    </div>
</div>
</body>
</html>
