<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $filePath = "tomochat.txt";

    // Username preso da POST (non più dalla query string)
    $username = isset($_POST['username']) ? trim($_POST['username']) : "Anonimo";

    // ---- GESTIONE IMMAGINI ----
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK && $_FILES['image']['size'] > 0) {
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));

        if ($ext !== "png") {
            die("Only png image file are accepted!");
        }

        $randomNumber = rand(100000, 9999999);
        $newFileName = $randomNumber . ".png";

        $destination = __DIR__ . "/../immagini/" . $newFileName;

        if (!move_uploaded_file($_FILES['image']['tmp_name'], $destination)) {
            die("Error while sending the image");
        }

        $newLine = $username . ": IMG>" . $newFileName;

        $currentContent = file_exists($filePath) ? file_get_contents($filePath) : "";
        $newContent = $newLine . PHP_EOL . $currentContent;
        file_put_contents($filePath, $newContent);

        echo "Image sended.";
        exit;
    }

    // ---- GESTIONE TESTO ----
    if (isset($_POST['text'])) {
        $text = trim($_POST['text']);

        if (mb_strlen($text) > 620) {
            die("Messaggio troppo lungo");
        }
        if (stripos($text, "FIX YOUR AI SLOP SITE") !== false) {
            die("Message contains forbidden text. Sending blocked.");
        }

        $lines = file_exists($filePath) ? file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
        if (!empty($lines)) {
            $lastLine = $lines[0];
            similar_text(mb_strtolower($lastLine), mb_strtolower($text), $percent);
            if ($percent > 80) {
                die("The message is too similar to the previvious one");
            }
        }

        $blockedFile = "bloccati.txt";
        $blockedWords = [];
        if (file_exists($blockedFile)) {
            $blockedWords = file($blockedFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        }
        foreach ($blockedWords as $word) {
            if (trim($word) === '') continue;
            $pattern = '/' . preg_quote($word, '/') . '/i';
            if (preg_match($pattern, $text)) {
                $replacement = str_repeat('#', mb_strlen($word));
                $text = preg_replace($pattern, $replacement, $text);
            }
        }

        $words = preg_split('/\s+/', mb_strtolower($text));
        $wordCounts = array_count_values($words);
        foreach ($wordCounts as $word => $count) {
            $totalLength = mb_strlen($word) * $count;
            if ($totalLength > 100) {
                die("The message contain too ripetition of '{$word}'. Sending blocked.");
            }
        }

        $currentContent = file_exists($filePath) ? file_get_contents($filePath) : "";
        $newContent = $text . PHP_EOL . $currentContent;
        file_put_contents($filePath, $newContent);

        echo "Message sended.";
    } else {
        echo "No message inserted.";
    }
} else {
    echo "The request is invalid. Use metod POST";
}
?>
