<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['text'])) {
        $text = trim($_POST['text']);

        // Check max length
        if (mb_strlen($text) > 620) {
            die("Message too long. Sending blocked.");
        }

        // Check duplicate with last line in tomochat.txt
        $filePath = "tomochat.txt";
        if (file_exists($filePath)) {
            $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            if (!empty($lines)) {
                $lastLine = $lines[0]; // first line because we prepend messages
                if ($lastLine === $text) {
                    die("Duplicate message. Sending blocked.");
                }
            }
        }

        // Load blocked words
        $blockedFile = "bloccati.txt";
        $blockedWords = [];
        if (file_exists($blockedFile)) {
            $blockedWords = file($blockedFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        }

        // Replace blocked words with ###
        foreach ($blockedWords as $word) {
            if (trim($word) === '') continue; // skip empty lines
            $pattern = '/' . preg_quote($word, '/') . '/i'; // match inside words too
            if (preg_match($pattern, $text)) {
                $replacement = str_repeat('#', mb_strlen($word));
                $text = preg_replace($pattern, $replacement, $text);
            }
        }

        // Check too many repetitions (based on total length)
        $words = preg_split('/\s+/', mb_strtolower($text));
        $wordCounts = array_count_values($words);
        foreach ($wordCounts as $word => $count) {
            $totalLength = mb_strlen($word) * $count;
            if ($totalLength > 100) { // e.g., if one word fills more than 100 chars
                die("Message contains too many repetitions of the word '{$word}'. Sending blocked.");
            }
        }

        // Write into the file (prepend new text)
        $currentContent = file_exists($filePath) ? file_get_contents($filePath) : "";
        $newContent = $text . PHP_EOL . $currentContent;
        file_put_contents($filePath, $newContent);

        echo "Message sent successfully.";
    } else {
        echo "No message provided.";
    }
} else {
    echo "Invalid request. Please use POST method.";
}
?>
