<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['text'])) {
        $text = trim($_POST['text']);

        // Controllo lunghezza massima
        if (mb_strlen($text) > 620) {
            die("Messaggio troppo lungo. Invio bloccato.");
        }

        // Controllo duplicato con l'ultima riga di tomochat.txt
        $filePath = "tomochat.txt";
        if (file_exists($filePath)) {
            $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            if (!empty($lines)) {
                $lastLine = $lines[0]; // prima riga perché scriviamo sempre in testa
                if ($lastLine === $text) {
                    die("Messaggio duplicato. Invio bloccato.");
                }
            }
        }

        // Carica parole bloccate
        $blockedFile = "bloccati.txt";
        $blockedWords = [];
        if (file_exists($blockedFile)) {
            $blockedWords = file($blockedFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        }

        // Sostituzione parole bloccate con ###
        foreach ($blockedWords as $word) {
            if (trim($word) === '') continue; // ignora righe vuote
            $pattern = '/' . preg_quote($word, '/') . '/i'; // match anche dentro altre parole
            if (preg_match($pattern, $text)) {
                $replacement = str_repeat('#', mb_strlen($word));
                $text = preg_replace($pattern, $replacement, $text);
            }
        }

        // Controllo troppe ripetizioni (basato sulla lunghezza totale)
        $words = preg_split('/\s+/', mb_strtolower($text));
        $wordCounts = array_count_values($words);
        foreach ($wordCounts as $word => $count) {
            $totalLength = mb_strlen($word) * $count;
            if ($totalLength > 100) { // es. se una parola supera 100 caratteri totali
                die("Messaggio contiene troppe ripetizioni della parola '{$word}'. Invio bloccato.");
            }
        }

        // Scrivi nel file (aggiunge in testa)
        $currentContent = file_exists($filePath) ? file_get_contents($filePath) : "";
        $newContent = $text . PHP_EOL . $currentContent;
        file_put_contents($filePath, $newContent);

        echo "Messaggio inviato con successo.";
    } else {
        echo "Nessun messaggio inserito.";
    }
} else {
    echo "Richiesta non valida. Usa il metodo POST.";
}
?>
