<?php
function generaCodiceCasuale($lunghezza = 15) {
    $caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $codice = '';
    for ($i = 0; $i < $lunghezza; $i++) {
        $codice .= $caratteri[random_int(0, strlen($caratteri) - 1)];
    }
    return $codice;
}

// Parametri GET
$session = $_GET['session'] ?? '';
$username = $_GET['username'] ?? 'guest';
$community = $_GET['community'] ?? 'default';

// Controllo session
$codiceFile = 'codice.txt';
$codiceCorrente = trim(file_get_contents($codiceFile));
if ($session !== $codiceCorrente) {
    header('Location: 3dsbloccoen.html');
    exit;
}

// Aggiorna codice
$nuovoCodice = generaCodiceCasuale();
file_put_contents($codiceFile, $nuovoCodice);

// Info community
$cartellaCommunity = $community;
$infoFile = $cartellaCommunity . '/informazionien.txt';
$info = file($infoFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$nome = $info[0] ?? 'Nome Community';
$banner = $info[1] ?? 'banner.jpg';
$logo = $info[2] ?? 'logo.png';

// Session verifica
$sessionValue = trim(file_get_contents('verifica.txt'));
?>
<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($nome); ?> - Citraverse</title>
<link href="3dstomodachistile7.css" rel="stylesheet">
<script>
let isScrolling = false;

// Aggiorna chat
function aggiornaChat() {
    if (isScrolling) return;
    const chatBox = document.getElementById("chatBox");
    fetch("chatvisual6.php?community=<?php echo urlencode($community); ?>&username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($sessionValue); ?>&t=" + new Date().getTime())
        .then(resp => resp.text())
        .then(html => {
            chatBox.innerHTML = html;
            chatBox.scrollTop = chatBox.scrollHeight;
        });
}

// refresh chat ogni 2 secondi
setInterval(aggiornaChat, 5000);

// refresh sendtomo iframe ogni 3 secondi
function aggiornaSendTomo() {
    const sendFrame = document.getElementById("sendTomoFrame");
    sendFrame.src = sendFrame.src.split('?')[0] + "?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($sessionValue); ?>&t=" + new Date().getTime();
}
setInterval(aggiornaSendTomo, 3000);

// blocco aggiornamento mentre scrolli
document.addEventListener("scroll", () => {
    isScrolling = true;
    clearTimeout(window.scrollTimeout);
    window.scrollTimeout = setTimeout(() => { isScrolling = false; }, 1000);
});

function goHome() {
    const username = "<?php echo $username; ?>";
    fetch("codice.txt").then(r => r.text()).then(code => {
        const codice = code.trim();
        window.location.href = "3dshomeen.php?username=" + encodeURIComponent(username) + "&session=" + encodeURIComponent(codice);
    });
}

window.onload = aggiornaChat;
</script>
</head>
<body>
    <!-- Banner -->
    <img src="<?php echo htmlspecialchars($banner); ?>" class="community-banner">

    <!-- Barra bianca -->
    <div class="navbar">
        <div class="logo-container">
            <img src="<?php echo htmlspecialchars($logo); ?>" class="community-logo">
            <span class="community-name"><?php echo htmlspecialchars($nome); ?></span>
        </div>
        <button class="home-btn" onclick="goHome()">Home</button>
    </div>

    <!-- Box chat (sfondo bianco) -->
    <div id="chatBox" class="chat-box"></div>

    <!-- Box invio (sendtomo.html) -->
    <iframe id="sendTomoFrame" class="iframe-send" src="<?php echo $cartellaCommunity; ?>/sendtomoen.html?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($sessionValue); ?>"></iframe>
</body>
</html>
