<?php
function generaCodiceCasuale($lunghezza = 15) {
    $caratteri = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $codice = '';
    for ($i = 0; $i < $lunghezza; $i++) {
        $codice .= $caratteri[random_int(0, strlen($caratteri) - 1)];
    }
    return $codice;
}

// Parametri GET
$session = $_GET['session'] ?? '';
$username = $_GET['username'] ?? 'guest';
$community = $_GET['community'] ?? 'default';

// Controllo session
$codiceFile = 'codice.txt';
$codiceCorrente = trim(file_get_contents($codiceFile));
if ($session !== $codiceCorrente) {
    header('Location: blocco.html');
    exit;
}

// Aggiorna codice
$nuovoCodice = generaCodiceCasuale();
file_put_contents($codiceFile, $nuovoCodice);

// Info community
$cartellaCommunity = $community;
$infoFile = $cartellaCommunity . '/informazioni.txt';
$info = file($infoFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$nome = $info[0] ?? 'Nome Community';
$banner = $info[1] ?? 'banner.jpg';
$logo = $info[2] ?? 'logo.png';

// Session verifica
$sessionValue = trim(file_get_contents('verifica.txt'));
?>
<!DOCTYPE html>
<html lang="it">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($nome); ?> - Citraverse</title>
<link href="tomodachistile7.css" rel="stylesheet">
<script>
function aggiornaChat() {
    const chatBox = document.getElementById("chatBox");
    fetch("chatvisual6.php?community=<?php echo urlencode($community); ?>&username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($sessionValue); ?>&t=" + new Date().getTime())
        .then(resp => resp.text())
        .then(html => {
            chatBox.innerHTML = html;
            chatBox.scrollTop = chatBox.scrollHeight;
        });
}

function aggiornaSendTomo() {
    const sendFrame = document.getElementById("sendTomoFrame");
    sendFrame.src = "<?php echo $cartellaCommunity; ?>/sendtomo.html?username=<?php echo urlencode($username); ?>&session=<?php echo urlencode($sessionValue); ?>&community=<?php echo urlencode($community); ?>&t=" + new Date().getTime();
}

function refreshAll() {
    aggiornaChat();
    aggiornaSendTomo();
}

function goHome() {
    const username = "<?php echo $username; ?>";
    fetch("codice.txt").then(r => r.text()).then(code => {
        const codice = code.trim();
        window.location.href = "home.php?username=" + encodeURIComponent(username) + "&session=" + encodeURIComponent(codice);
    });
}

window.onload = function() {
    // carica inizialmente
    aggiornaChat();
    aggiornaSendTomo();
};
</script>
</head>
<body>
    <!-- Banner -->
    <img src="<?php echo htmlspecialchars($banner); ?>" class="community-banner">

    <!-- Barra bianca -->
    <div class="navbar">
        <div class="logo-container">
            <img src="<?php echo htmlspecialchars($logo); ?>" class="community-logo">
            <span class="community-name"><?php echo htmlspecialchars($nome); ?></span>
        </div>
        <button class="home-btn" onclick="goHome()">Home</button>
    </div>

    <!-- Pulsante Refresh -->
    <button class="refresh-btn" onclick="refreshAll()">Refresh</button>

    <!-- Box chat -->
    <div id="chatBox" class="chat-box"></div>

    <!-- Box invio (sendtomo.html) -->
    <iframe id="sendTomoFrame" class="iframe-send"></iframe>
</body>
</html>
